/*
 * Decompiled with CFR 0.152.
 */
package dr.stats;

import dr.stats.Variate;

public class Regression {
    private Variate.D xData = null;
    private Variate.D yData = null;
    private boolean forceOrigin = false;
    private boolean regressionKnown = false;
    private double gradient;
    private double intercept;
    private double covariance;
    private double sumResidualsSquared;
    private double residualMeanSquared;
    private double correlationCoefficient;

    public Regression() {
    }

    public Regression(Variate variate, Variate variate2) {
        this.setData(variate, variate2);
    }

    public Regression(double[] dArray, double[] dArray2) {
        this.setData(dArray, dArray2);
    }

    public Regression(Variate variate, Variate variate2, boolean bl) {
        this.setData(variate, variate2);
        this.setForceOrigin(bl);
    }

    public Regression(double[] dArray, double[] dArray2, boolean bl) {
        this.setData(dArray, dArray2);
        this.setForceOrigin(bl);
    }

    public void setData(double[] dArray, double[] dArray2) {
        Variate.D d = new Variate.D();
        Variate.D d2 = new Variate.D();
        for (int i = 0; i < dArray.length; ++i) {
            d.add(dArray[i]);
            d2.add(dArray2[i]);
        }
        this.xData = d;
        this.yData = d2;
        this.regressionKnown = false;
    }

    public void setData(Variate variate, Variate variate2) {
        this.xData = (Variate.D)variate;
        this.yData = (Variate.D)variate2;
        this.regressionKnown = false;
    }

    public void setForceOrigin(boolean bl) {
        this.forceOrigin = bl;
        this.regressionKnown = false;
    }

    public double getGradient() {
        if (!this.regressionKnown) {
            this.calculateRegression();
        }
        return this.gradient;
    }

    public double getIntercept() {
        if (!this.regressionKnown) {
            this.calculateRegression();
        }
        return this.intercept;
    }

    public double getYIntercept() {
        return this.getIntercept();
    }

    public double getXIntercept() {
        return -this.getIntercept() / this.getGradient();
    }

    public double getCovariance() {
        if (!this.regressionKnown) {
            this.calculateRegression();
        }
        return this.covariance;
    }

    public double getResidualMeanSquared() {
        if (!this.regressionKnown) {
            this.calculateRegression();
        }
        return this.residualMeanSquared;
    }

    public double getSumResidualsSquared() {
        if (!this.regressionKnown) {
            this.calculateRegression();
        }
        return this.sumResidualsSquared;
    }

    public double getCorrelationCoefficient() {
        if (!this.regressionKnown) {
            this.calculateRegression();
        }
        return this.correlationCoefficient;
    }

    public double getRSquared() {
        if (!this.regressionKnown) {
            this.calculateRegression();
        }
        return this.correlationCoefficient * this.correlationCoefficient;
    }

    public double getResidual(double d, double d2) {
        return d2 - (this.getGradient() * d + this.getIntercept());
    }

    public double getX(double d) {
        return (d - this.getIntercept()) / this.getGradient();
    }

    public double getY(double d) {
        return d * this.getGradient() + this.getIntercept();
    }

    public Variate.N getXData() {
        return this.xData;
    }

    public Variate.N getYData() {
        return this.yData;
    }

    public Variate getYResidualData() {
        Variate.D d = new Variate.D();
        for (int i = 0; i < this.xData.getCount(); ++i) {
            d.add(this.getResidual((Double)this.xData.get(i), (Double)this.yData.get(i)));
        }
        return d;
    }

    private void calculateRegression() {
        int n;
        int n2 = this.xData.getCount();
        double d = 0.0;
        double d2 = 0.0;
        if (!this.forceOrigin) {
            d = this.xData.getMean();
            d2 = this.yData.getMean();
        }
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (n = 0; n < n2; ++n) {
            double d6 = (Double)this.xData.get(n) - d;
            double d7 = (Double)this.yData.get(n) - d2;
            d3 += d6 * d7;
            d4 += d6 * d6;
            d5 += d7 * d7;
        }
        this.gradient = d3 / d4;
        this.intercept = d2 - this.gradient * d;
        this.covariance = d3 / (double)(n2 - 1);
        this.correlationCoefficient = d3 / Math.sqrt(d4 * d5);
        this.sumResidualsSquared = 0.0;
        for (n = 0; n < n2; ++n) {
            double d8 = (Double)this.yData.get(n) - (this.gradient * (Double)this.xData.get(n) + this.intercept);
            this.sumResidualsSquared += d8 * d8;
        }
        this.residualMeanSquared = this.sumResidualsSquared / (double)(n2 - 2);
        this.regressionKnown = true;
    }
}

