/*
 * Decompiled with CFR 0.152.
 */
package dr.xml.unittest;

import dr.inference.model.Parameter;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.Reportable;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class ParameterValuesReport
implements Reportable {
    private final Parameter parameter;
    private static final String PARAMETER_VALUES = "parameterValues";
    public static final AbstractXMLObjectParser PARSER = new AbstractXMLObjectParser(){

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Parameter parameter = (Parameter)xMLObject.getChild(Parameter.class);
            return new ParameterValuesReport(parameter);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{new ElementRule(Parameter.class)};
        }

        @Override
        public String getParserDescription() {
            return "prints parameter values to string";
        }

        @Override
        public Class getReturnType() {
            return ParameterValuesReport.class;
        }

        @Override
        public String getParserName() {
            return ParameterValuesReport.PARAMETER_VALUES;
        }
    };

    public ParameterValuesReport(Parameter parameter) {
        this.parameter = parameter;
    }

    @Override
    public String getReport() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.parameter.getDimension(); ++i) {
            stringBuilder.append(this.parameter.getParameterValue(i));
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }
}

