/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.io;

import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import jebl.evolution.io.ByteBuilder;
import jebl.evolution.io.ImportException;
import jebl.evolution.sequences.SequenceType;
import jebl.util.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportHelper {
    private LineNumberReader reader;
    private BufferedWriter commentWriter = null;
    private char lastChar = '\u0000';
    private char lastDelimiter = '\u0000';
    private boolean hasComments = false;
    private char startComment = (char)65535;
    private char stopComment = (char)65535;
    private char lineComment = (char)65535;
    private char writeComment = (char)65535;
    private char metaComment = (char)65535;
    private String lastMetaComment = null;
    private final List<String> lastMetaComments = new ArrayList<String>();
    private long totalCharactersRead = 0L;
    private long expectedInputLength = 0L;
    private static final Pattern safeNamePattern = Pattern.compile("[a-zA-Z0-9_.]+");
    private static final Pattern controlsCharsPattern = Pattern.compile("[^\\p{Cntrl}]+");

    public ImportHelper(Reader reader) {
        this.reader = new LineNumberReader(reader);
        this.commentWriter = null;
    }

    public void setExpectedInputLength(long l) {
        this.expectedInputLength = l;
    }

    public ImportHelper(Reader reader, Writer commentWriter) {
        this.reader = new LineNumberReader(reader);
        this.commentWriter = new BufferedWriter(commentWriter);
    }

    public double getProgress() {
        if (this.expectedInputLength == 0L) {
            return 0.0;
        }
        return (double)this.totalCharactersRead / (double)this.expectedInputLength;
    }

    public void closeReader() throws IOException {
        this.reader.close();
    }

    public void setCommentDelimiters(char line) {
        this.hasComments = true;
        this.lineComment = line;
    }

    public void setCommentDelimiters(char start, char stop) {
        this.hasComments = true;
        this.startComment = start;
        this.stopComment = stop;
    }

    public void setCommentDelimiters(char start, char stop, char line) {
        this.hasComments = true;
        this.startComment = start;
        this.stopComment = stop;
        this.lineComment = line;
    }

    public void setCommentDelimiters(char start, char stop, char line, char write, char meta) {
        this.hasComments = true;
        this.startComment = start;
        this.stopComment = stop;
        this.lineComment = line;
        this.writeComment = write;
        this.metaComment = meta;
    }

    public void setCommentWriter(Writer commentWriter) {
        this.commentWriter = new BufferedWriter(commentWriter);
    }

    public int getLineNumber() {
        return this.reader.getLineNumber();
    }

    public int getLastDelimiter() {
        return this.lastDelimiter;
    }

    public char nextCharacter() throws IOException {
        if (this.lastChar == '\u0000') {
            this.lastChar = this.readCharacter();
        }
        return this.lastChar;
    }

    public char readCharacter() throws IOException {
        this.skipSpace();
        char ch = this.read();
        while (this.hasComments && (ch == this.startComment || ch == this.lineComment)) {
            this.skipComments(ch);
            this.skipSpace();
            ch = this.read();
        }
        return ch;
    }

    public void unreadCharacter(char ch) {
        this.lastChar = ch;
    }

    public char next() throws IOException {
        if (this.lastChar == '\u0000') {
            this.lastChar = this.read();
        }
        return this.lastChar;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public char read() throws IOException {
        int ch;
        if (this.lastChar == '\u0000') {
            ch = this.reader.read();
            if (ch == -1) throw new EOFException();
            ++this.totalCharactersRead;
            return (char)ch;
        } else {
            ch = this.lastChar;
            this.lastChar = '\u0000';
        }
        return (char)ch;
    }

    private String readLine(boolean skipComments) throws IOException {
        StringBuilder line = new StringBuilder();
        char ch = this.read();
        try {
            while (ch != '\n' && ch != '\r') {
                if (this.hasComments && skipComments) {
                    if (ch == this.lineComment) {
                        this.skipComments(ch);
                        break;
                    }
                    if (ch == this.startComment) {
                        this.skipComments(ch);
                        ch = this.read();
                    }
                }
                line.append(ch);
                ch = this.read();
            }
            if (ch == '\r' && this.next() == '\n') {
                this.read();
            }
            this.lastDelimiter = ch;
        }
        catch (EOFException e) {
            // empty catch block
        }
        return line.toString();
    }

    public String readLine() throws IOException {
        return this.readLine(true);
    }

    public void readSequence(StringBuilder sequence, SequenceType sequenceType, String delimiters, int maxSites, String gapCharacters, String missingCharacters, String matchCharacters, String matchSequence) throws IOException, ImportException {
        this.readSequence(sequence, sequenceType, delimiters, maxSites, gapCharacters, missingCharacters, matchCharacters, matchSequence, ProgressListener.EMPTY);
    }

    public void readSequence(StringBuilder sequence, SequenceType sequenceType, String delimiters, int maxSites, String gapCharacters, String missingCharacters, String matchCharacters, String matchSequence, boolean stopAtDoubleNewLine) throws IOException, ImportException {
        this.readSequence(sequence, sequenceType, delimiters, maxSites, gapCharacters, missingCharacters, matchCharacters, matchSequence, ProgressListener.EMPTY, stopAtDoubleNewLine);
    }

    public void readSequence(StringBuilder sequence, SequenceType sequenceType, String delimiters, int maxSites, String gapCharacters, String missingCharacters, String matchCharacters, String matchSequence, ProgressListener progress) throws IOException, ImportException {
        this.readSequence(sequence, sequenceType, delimiters, maxSites, gapCharacters, missingCharacters, matchCharacters, matchSequence, progress, false);
    }

    public void readSequence(StringBuilder sequence, SequenceType sequenceType, String delimiters, int maxSites, String gapCharacters, String missingCharacters, String matchCharacters, String matchSequence, ProgressListener progress, boolean stopAtDoubleNewLine) throws IOException, ImportException {
        char ch = this.read();
        char gapCode = sequenceType.getGapState().getCode().charAt(0);
        char unknownCode = sequenceType.getUnknownState().getCode().charAt(0);
        int byteBuilderMaxCapacity = this.expectedInputLength == 0L || this.expectedInputLength > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.expectedInputLength;
        Appendable builder = new ByteBuilder(byteBuilderMaxCapacity);
        assert (builder instanceof CharSequence);
        try {
            int nSites = 0;
            boolean doubleNewLine = false;
            while (!(stopAtDoubleNewLine && doubleNewLine || nSites >= maxSites || delimiters.indexOf(ch) != -1)) {
                if (nSites % 1024 == 0 && progress.setProgress(this.getProgress())) {
                    return;
                }
                if (this.hasComments && (ch == this.startComment || ch == this.lineComment)) {
                    this.skipComments(ch);
                    ch = this.read();
                }
                if (!Character.isWhitespace(ch)) {
                    if (gapCharacters.indexOf(ch) != -1) {
                        builder.append(gapCode);
                    } else if (missingCharacters.indexOf(ch) != -1) {
                        builder.append(unknownCode);
                    } else if (matchCharacters.indexOf(ch) != -1) {
                        if (matchSequence == null) {
                            throw new ImportException("Match character in first sequences");
                        }
                        if (nSites >= matchSequence.length()) {
                            throw new ImportException("Match sequences too short");
                        }
                        builder.append(matchSequence.charAt(nSites));
                    } else if (!ByteBuilder.isCharacterAscii(ch) && builder instanceof ByteBuilder) {
                        builder = new StringBuilder((CharSequence)((Object)builder));
                        assert (builder instanceof CharSequence);
                    } else {
                        builder.append(ch);
                    }
                    ++nSites;
                }
                char previous = ch;
                ch = this.read();
                if (previous != '\n' || ch != '\n') continue;
                doubleNewLine = true;
            }
            this.lastDelimiter = ch;
            if (Character.isWhitespace(this.lastDelimiter) && delimiters.indexOf(ch = this.nextCharacter()) != -1) {
                this.lastDelimiter = this.readCharacter();
            }
        }
        catch (EOFException e) {
            // empty catch block
        }
        sequence.append((CharSequence)((Object)builder));
    }

    public void readSequenceLine(StringBuffer sequence, SequenceType sequenceType, String delimiters, String gapCharacters, String missingCharacters, String matchCharacters, String matchSequence) throws IOException, ImportException {
        char ch = this.read();
        try {
            int n = 0;
            while (ch != '\r' && ch != '\n' && delimiters.indexOf(ch) == -1) {
                if (this.hasComments) {
                    if (ch == this.lineComment) {
                        this.skipComments(ch);
                        break;
                    }
                    if (ch == this.startComment) {
                        this.skipComments(ch);
                        ch = this.read();
                        continue;
                    }
                }
                if (ch != ' ' && ch != '\t') {
                    if (gapCharacters.indexOf(ch) != -1) {
                        sequence.append(sequenceType.getGapState().getCode());
                    } else if (missingCharacters.indexOf(ch) != -1) {
                        sequence.append(sequenceType.getUnknownState().getCode());
                    } else if (matchCharacters.indexOf(ch) != -1) {
                        if (matchSequence == null) {
                            throw new ImportException("Match character in first sequences");
                        }
                        if (n >= matchSequence.length()) {
                            throw new ImportException("Match sequences too short");
                        }
                        sequence.append(matchSequence.charAt(n));
                    } else {
                        sequence.append(ch);
                    }
                    ++n;
                }
                ch = this.read();
            }
            if (ch == '\r' && this.next() == '\n') {
                this.read();
            }
            this.lastDelimiter = ch;
            if (Character.isWhitespace(this.lastDelimiter) && delimiters.indexOf(ch = this.nextCharacter()) != -1) {
                this.lastDelimiter = this.readCharacter();
            }
        }
        catch (EOFException e) {
            // empty catch block
        }
    }

    public int readInteger() throws IOException, ImportException {
        String token = this.readToken();
        try {
            return Integer.parseInt(token);
        }
        catch (NumberFormatException nfe) {
            throw new ImportException("Number format error: " + nfe.getMessage());
        }
    }

    public int readInteger(String delimiters) throws IOException, ImportException {
        String token = this.readToken(delimiters);
        try {
            return Integer.parseInt(token);
        }
        catch (NumberFormatException nfe) {
            throw new ImportException("Number format error: " + nfe.getMessage());
        }
    }

    public double readDouble() throws IOException, ImportException {
        String token = this.readToken();
        try {
            return Double.parseDouble(token);
        }
        catch (NumberFormatException nfe) {
            throw new ImportException("Number format error: " + nfe.getMessage());
        }
    }

    public double readDouble(String delimiters) throws IOException, ImportException {
        String token = this.readToken(delimiters);
        try {
            return Double.parseDouble(token);
        }
        catch (NumberFormatException nfe) {
            throw new ImportException("Number format error: " + nfe.getMessage());
        }
    }

    public String readToken() throws IOException {
        return this.readToken("");
    }

    public String readToken(String delimiters) throws IOException {
        char ch;
        char quoteChar = '\u0000';
        boolean done = false;
        boolean first = true;
        boolean quoted = false;
        this.nextCharacter();
        StringBuffer token = new StringBuffer();
        while (!done) {
            ch = this.read();
            try {
                boolean isSpace = Character.isWhitespace(ch);
                if (quoted && ch == quoteChar) {
                    char ch2 = this.read();
                    if (ch == ch2) {
                        token.append(ch);
                        continue;
                    }
                    this.lastDelimiter = (char)32;
                    if (this.hasComments && (ch2 == this.startComment || ch2 == this.lineComment)) {
                        this.skipComments(ch2, this.startComment != '\"' && this.startComment != '\'');
                    } else {
                        this.unreadCharacter(ch2);
                    }
                    done = true;
                    quoted = false;
                    continue;
                }
                if (first && (ch == '\'' || ch == '\"')) {
                    quoted = true;
                    quoteChar = ch;
                    first = false;
                    continue;
                }
                if (!(quoted || ch != this.startComment && ch != this.lineComment)) {
                    this.skipComments(ch, this.startComment != '\"' && this.startComment != '\'');
                    this.lastDelimiter = (char)32;
                    done = true;
                    continue;
                }
                if (quoted) {
                    token.append(ch);
                    continue;
                }
                if (isSpace) {
                    this.lastDelimiter = (char)32;
                    done = true;
                    continue;
                }
                if (delimiters.indexOf(ch) != -1) {
                    done = true;
                    this.lastDelimiter = ch;
                    continue;
                }
                token.append(ch);
                first = false;
            }
            catch (EOFException e) {
                done = true;
            }
        }
        if (Character.isWhitespace(this.lastDelimiter)) {
            ch = this.nextCharacter();
            while (Character.isWhitespace(ch)) {
                this.read();
                ch = this.nextCharacter();
            }
            if (delimiters.indexOf(ch) != -1) {
                this.lastDelimiter = this.readCharacter();
            }
        }
        return token.toString();
    }

    protected void skipComments(char delimiter) throws IOException {
        this.skipComments(delimiter, false);
    }

    protected void skipComments(char delimiter, boolean gobbleStrings) throws IOException {
        int n = 1;
        boolean write = false;
        StringBuffer meta = null;
        if (this.nextCharacter() == this.writeComment) {
            this.read();
            write = true;
        } else if (this.nextCharacter() == this.metaComment) {
            this.read();
            meta = new StringBuffer();
        }
        this.lastMetaComment = null;
        if (delimiter == this.lineComment) {
            String line = this.readLine(false);
            if (write && this.commentWriter != null) {
                this.commentWriter.write(line);
                this.commentWriter.newLine();
            } else if (meta != null) {
                meta.append(line);
            }
        } else {
            Character inString = null;
            do {
                char ch;
                if (((ch = this.read()) == '\"' || ch == '\'') && gobbleStrings) {
                    if (inString == null) {
                        inString = Character.valueOf(ch);
                    } else if (inString.charValue() == ch) {
                        inString = null;
                    }
                }
                if (inString == null) {
                    if (ch == this.startComment) {
                        ++n;
                        continue;
                    }
                    if (ch == this.stopComment) {
                        if (write && this.commentWriter != null) {
                            this.commentWriter.newLine();
                        }
                        --n;
                        continue;
                    }
                }
                if (write && this.commentWriter != null) {
                    this.commentWriter.write(ch);
                    continue;
                }
                if (meta == null) continue;
                meta.append(ch);
            } while (n > 0);
        }
        if (meta != null) {
            this.lastMetaComment = meta.toString();
            this.lastMetaComments.add(this.lastMetaComment);
        }
    }

    public void skipToEndOfLine() throws IOException {
        char ch;
        do {
            ch = this.read();
            if (!this.hasComments) continue;
            if (ch == this.lineComment) {
                this.skipComments(ch);
                break;
            }
            if (ch != this.startComment) continue;
            this.skipComments(ch);
            ch = this.read();
        } while (ch != '\n' && ch != '\r');
        if (ch == '\r' && this.nextCharacter() == '\n') {
            this.read();
        }
    }

    public void skipWhile(String skip) throws IOException {
        char ch;
        while (skip.indexOf(ch = this.read()) > -1) {
        }
        this.unreadCharacter(ch);
    }

    public void skipSpace() throws IOException {
        this.skipWhile(" \t\r\n");
    }

    public void skipCharacters(String skip) throws IOException {
        this.skipWhile(skip + " \t\r\n");
    }

    public char skipUntil(String skip) throws IOException {
        char ch;
        while (skip.indexOf(ch = this.readCharacter()) == -1) {
        }
        return ch;
    }

    public List<String> getMetaComments() {
        return new ArrayList<String>(this.lastMetaComments);
    }

    @Deprecated
    public String getLastMetaComment() {
        return this.lastMetaComment;
    }

    public void clearLastMetaComment() {
        this.lastMetaComment = null;
        this.lastMetaComments.clear();
    }

    static String safeName(String name) {
        if (!safeNamePattern.matcher(name).matches()) {
            name = "\"" + name + "\"";
        }
        return name;
    }

    static String convertControlsChars(String token) {
        if (!controlsCharsPattern.matcher(token).matches()) {
            StringBuilder b = new StringBuilder();
            for (char c : token.toCharArray()) {
                if (c < ' ' || c >= '\u00fe') {
                    b.append("#").append(Integer.toHexString(c));
                    continue;
                }
                b.append(c);
            }
            return b.toString();
        }
        return token;
    }
}

