/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.sequences;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import jebl.evolution.sequences.Sequence;
import jebl.evolution.sequences.SequenceType;
import jebl.evolution.sequences.State;
import jebl.evolution.taxa.Taxon;
import jebl.util.AttributableHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicSequence
implements Sequence {
    private AttributableHelper helper = null;
    private final Taxon taxon;
    private final SequenceType sequenceType;
    private final byte[] sequenceCharacters;

    public BasicSequence(SequenceType sequenceType, Taxon taxon, CharSequence sequenceString) {
        if (sequenceType == null) {
            throw new IllegalArgumentException("sequenceType is not allowed to be null");
        }
        if (taxon == null) {
            throw new IllegalArgumentException("taxon is not allowed to be null");
        }
        this.sequenceType = sequenceType;
        this.taxon = taxon;
        int len = sequenceString.length();
        this.sequenceCharacters = new byte[len];
        for (int i = 0; i < len; ++i) {
            char c = sequenceString.charAt(i);
            State state = sequenceType.getState(c);
            this.sequenceCharacters[i] = state == null ? 63 : (byte)c;
        }
    }

    public BasicSequence(SequenceType sequenceType, Taxon taxon, State[] states) {
        this.sequenceType = sequenceType;
        this.taxon = taxon;
        this.sequenceCharacters = new byte[states.length];
        for (int i = 0; i < this.sequenceCharacters.length; ++i) {
            this.sequenceCharacters[i] = (byte)states[i].getCode().charAt(0);
        }
    }

    @Override
    public SequenceType getSequenceType() {
        return this.sequenceType;
    }

    @Override
    public String getString() {
        StringBuilder buffer = new StringBuilder(this.sequenceCharacters.length);
        for (byte i : this.sequenceCharacters) {
            buffer.append((char)i);
        }
        return buffer.toString();
    }

    public String getCleanString() {
        StringBuilder buffer = new StringBuilder(this.sequenceCharacters.length);
        for (byte i : this.sequenceCharacters) {
            State state = this.sequenceType.getState((char)i);
            if (state.isAmbiguous() || state.isGap()) continue;
            buffer.append(this.sequenceType.getState(i).getCode());
        }
        return buffer.toString();
    }

    @Override
    public State[] getStates() {
        return this.sequenceType.toStateArray(this.getStateIndices());
    }

    @Override
    public byte[] getStateIndices() {
        byte[] results = new byte[this.sequenceCharacters.length];
        for (int i = 0; i < this.sequenceCharacters.length; ++i) {
            results[i] = (byte)this.getState(i).getIndex();
        }
        return results;
    }

    public byte[] getSequenceCharacters() {
        return this.sequenceCharacters;
    }

    @Override
    public State getState(int site) {
        return this.sequenceType.getState((char)this.sequenceCharacters[site]);
    }

    @Override
    public int getLength() {
        return this.sequenceCharacters.length;
    }

    @Override
    public Taxon getTaxon() {
        return this.taxon;
    }

    public int compareTo(Object o) {
        return this.taxon.compareTo(((Sequence)o).getTaxon());
    }

    public String toString() {
        return this.getString();
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (this.helper == null) {
            this.helper = new AttributableHelper();
        }
        this.helper.setAttribute(name, value);
    }

    @Override
    public Object getAttribute(String name) {
        if (this.helper == null) {
            return null;
        }
        return this.helper.getAttribute(name);
    }

    @Override
    public void removeAttribute(String name) {
        if (this.helper != null) {
            this.helper.removeAttribute(name);
        }
    }

    @Override
    public Set<String> getAttributeNames() {
        if (this.helper == null) {
            return Collections.emptySet();
        }
        return this.helper.getAttributeNames();
    }

    @Override
    public Map<String, Object> getAttributeMap() {
        if (this.helper == null) {
            return Collections.emptyMap();
        }
        return this.helper.getAttributeMap();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicSequence that = (BasicSequence)o;
        if (!Arrays.equals(this.sequenceCharacters, that.sequenceCharacters)) {
            return false;
        }
        if (this.sequenceType != null ? !this.sequenceType.equals(that.sequenceType) : that.sequenceType != null) {
            return false;
        }
        return !(this.taxon != null ? !this.taxon.equals(that.taxon) : that.taxon != null);
    }

    public int hashCode() {
        int result = this.taxon != null ? this.taxon.hashCode() : 0;
        result = 31 * result + (this.sequenceType != null ? this.sequenceType.hashCode() : 0);
        result = 31 * result + (this.sequenceCharacters != null ? Arrays.hashCode(this.sequenceCharacters) : 0);
        return result;
    }
}

