/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Interface;
import no.uib.cipr.matrix.LowerTriangDenseMatrix;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.OrthogonalComputer;

public class QL
extends OrthogonalComputer {
    public QL(int m, int n) {
        super(m, n, false);
        if (n > m) {
            throw new IllegalArgumentException("n > m");
        }
        this.work = new double[1];
        int info = Interface.lapack().geqlf(m, n, new double[0], new double[0], this.work, -1);
        int lwork = info != 0 ? n : (int)this.work[0];
        lwork = Math.max(1, lwork);
        this.work = new double[lwork];
        this.workGen = new double[1];
        info = Interface.lapack().orgql(m, n, this.k, new double[0], new double[0], this.workGen, -1);
        lwork = info != 0 ? n : (int)this.workGen[0];
        lwork = Math.max(1, lwork);
        this.workGen = new double[lwork];
    }

    public static QL factorize(Matrix A) {
        return new QL(A.numRows(), A.numColumns()).factor(new DenseMatrix(A));
    }

    public QL factor(DenseMatrix A) {
        if (this.Q.numRows() != A.numRows()) {
            throw new IllegalArgumentException("Q.numRows() != A.numRows()");
        }
        if (this.Q.numColumns() != A.numColumns()) {
            throw new IllegalArgumentException("Q.numColumns() != A.numColumns()");
        }
        if (this.L == null) {
            throw new IllegalArgumentException("L == null");
        }
        int info = Interface.lapack().geqlf(this.m, this.n, A.getData(), this.tau, this.work, this.work.length);
        if (info < 0) {
            throw new IllegalArgumentException();
        }
        this.L.zero();
        for (MatrixEntry e : A) {
            if (e.row() < this.m - this.n + e.column()) continue;
            this.L.set(e.row() - (this.m - this.n), e.column(), e.get());
        }
        info = Interface.lapack().orgql(this.m, this.n, this.k, A.getData(), this.tau, this.workGen, this.workGen.length);
        if (info < 0) {
            throw new IllegalArgumentException();
        }
        this.Q.set(A);
        return this;
    }

    public LowerTriangDenseMatrix getL() {
        return this.L;
    }
}

