/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import java.util.Arrays;
import java.util.Iterator;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.VectorEntry;
import no.uib.cipr.matrix.sparse.SparseVector;
import no.uib.cipr.matrix.sparse.SuperIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlexCompRowMatrix
extends AbstractMatrix {
    SparseVector[] rowD;

    public FlexCompRowMatrix(int numRows, int numColumns) {
        super(numRows, numColumns);
        this.rowD = new SparseVector[numRows];
        for (int i = 0; i < numRows; ++i) {
            this.rowD[i] = new SparseVector(numColumns);
        }
    }

    public FlexCompRowMatrix(Matrix A, boolean deep) {
        super(A);
        this.rowD = new SparseVector[this.numRows];
        if (deep) {
            for (int i = 0; i < this.numRows; ++i) {
                this.rowD[i] = new SparseVector(this.numColumns);
            }
            this.set(A);
        } else {
            FlexCompRowMatrix Ar = (FlexCompRowMatrix)A;
            for (int i = 0; i < this.numRows; ++i) {
                this.rowD[i] = Ar.getRow(i);
            }
        }
    }

    public FlexCompRowMatrix(Matrix A) {
        this(A, true);
    }

    public SparseVector getRow(int i) {
        return this.rowD[i];
    }

    public void setRow(int i, SparseVector x) {
        if (x.size() != this.numColumns) {
            throw new IllegalArgumentException("New row must be of the same size as existing row");
        }
        this.rowD[i] = x;
    }

    @Override
    public Vector multAdd(double alpha, Vector x, Vector y) {
        this.checkMultAdd(x, y);
        for (int i = 0; i < this.numRows; ++i) {
            y.add(i, alpha * this.rowD[i].dot(x));
        }
        return y;
    }

    @Override
    public Vector transMultAdd(double alpha, Vector x, Vector y) {
        if (!(x instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.transMultAdd(alpha, x, y);
        }
        this.checkTransMultAdd(x, y);
        double[] xd = ((DenseVector)x).getData();
        double[] yd = ((DenseVector)y).getData();
        y.scale(1.0 / alpha);
        for (int i = 0; i < this.numRows; ++i) {
            SparseVector v = this.rowD[i];
            int[] index = v.getIndex();
            double[] data = v.getData();
            int length = v.getUsed();
            for (int j = 0; j < length; ++j) {
                int n = index[j];
                yd[n] = yd[n] + data[j] * xd[i];
            }
        }
        return y.scale(alpha);
    }

    @Override
    public void add(int row, int column, double value) {
        this.rowD[row].add(column, value);
    }

    @Override
    public void set(int row, int column, double value) {
        this.rowD[row].set(column, value);
    }

    @Override
    public double get(int row, int column) {
        return this.rowD[row].get(column);
    }

    @Override
    public Iterator<MatrixEntry> iterator() {
        return new RowMatrixIterator();
    }

    @Override
    public Matrix copy() {
        return new FlexCompRowMatrix(this);
    }

    @Override
    public FlexCompRowMatrix zero() {
        for (int i = 0; i < this.numRows; ++i) {
            this.rowD[i].zero();
        }
        return this;
    }

    @Override
    public Matrix set(Matrix B) {
        if (!(B instanceof FlexCompRowMatrix)) {
            return super.set(B);
        }
        this.checkSize(B);
        FlexCompRowMatrix Bc = (FlexCompRowMatrix)B;
        for (int i = 0; i < this.numRows; ++i) {
            this.rowD[i].set(Bc.rowD[i]);
        }
        return this;
    }

    public void compact() {
        for (SparseVector v : this.rowD) {
            v.compact();
        }
    }

    private static class RowMatrixEntry
    implements MatrixEntry {
        private int row;
        private VectorEntry entry;

        private RowMatrixEntry() {
        }

        public void update(int row, VectorEntry entry) {
            this.row = row;
            this.entry = entry;
        }

        public int row() {
            return this.row;
        }

        public int column() {
            return this.entry.index();
        }

        public double get() {
            return this.entry.get();
        }

        public void set(double value) {
            this.entry.set(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RowMatrixIterator
    implements Iterator<MatrixEntry> {
        private SuperIterator<SparseVector, VectorEntry> iterator;
        private RowMatrixEntry entry;

        private RowMatrixIterator() {
            this.iterator = new SuperIterator(Arrays.asList(FlexCompRowMatrix.this.rowD));
            this.entry = new RowMatrixEntry();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public MatrixEntry next() {
            Object se = this.iterator.next();
            this.entry.update(((SuperIterator.SuperIteratorEntry)se).index(), (VectorEntry)((SuperIterator.SuperIteratorEntry)se).get());
            return this.entry;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

