/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol;

import org.ejml.alg.block.BlockMatrixOps;
import org.ejml.alg.block.linsol.chol.BlockCholeskyOuterSolver;
import org.ejml.data.BlockMatrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.interfaces.decomposition.DecompositionInterface;
import org.ejml.interfaces.linsol.LinearSolver;

public class LinearSolver_B64_to_D64
implements LinearSolver<DenseMatrix64F> {
    protected LinearSolver<BlockMatrix64F> alg = new BlockCholeskyOuterSolver();
    protected BlockMatrix64F blockA = new BlockMatrix64F(1, 1);
    protected BlockMatrix64F blockB = new BlockMatrix64F(1, 1);
    protected BlockMatrix64F blockX = new BlockMatrix64F(1, 1);

    public LinearSolver_B64_to_D64(LinearSolver<BlockMatrix64F> alg) {
        this.alg = alg;
    }

    @Override
    public boolean setA(DenseMatrix64F A) {
        this.blockA.reshape(A.numRows, A.numCols, false);
        BlockMatrixOps.convert(A, this.blockA);
        return this.alg.setA(this.blockA);
    }

    @Override
    public double quality() {
        return this.alg.quality();
    }

    @Override
    public void solve(DenseMatrix64F B, DenseMatrix64F X) {
        this.blockB.reshape(B.numRows, B.numCols, false);
        this.blockX.reshape(X.numRows, X.numCols, false);
        BlockMatrixOps.convert(B, this.blockB);
        this.alg.solve(this.blockB, this.blockX);
        BlockMatrixOps.convert(this.blockX, X);
    }

    @Override
    public void invert(DenseMatrix64F A_inv) {
        this.blockB.reshape(A_inv.numRows, A_inv.numCols, false);
        this.alg.invert(this.blockB);
        BlockMatrixOps.convert(this.blockB, A_inv);
    }

    @Override
    public boolean modifiesA() {
        return false;
    }

    @Override
    public boolean modifiesB() {
        return false;
    }

    @Override
    public <D extends DecompositionInterface> D getDecomposition() {
        return this.alg.getDecomposition();
    }
}

