## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
options(Ncpus = 1)

## ----setup--------------------------------------------------------------------
library(validate)
library(errorlocate)

## -----------------------------------------------------------------------------
rules <- validator(age > 0)

## -----------------------------------------------------------------------------
"age, income
 -10,    0  
  15, 2000
  25, 3000
  NA, 1000
" -> csv
d <- read.csv(textConnection(csv), strip.white = TRUE)

## ----echo = FALSE-------------------------------------------------------------
d

## -----------------------------------------------------------------------------
le <- locate_errors(d, rules)
summary(le)

## -----------------------------------------------------------------------------
le$errors

## -----------------------------------------------------------------------------
rules <- validator( r1 = age > 0
                  , r2 = if (income > 0) age > 16
                  )

## -----------------------------------------------------------------------------
summary(confront(d, rules))

## -----------------------------------------------------------------------------
set.seed(1)
le <- locate_errors(d, rules)
le$errors

## -----------------------------------------------------------------------------
d_fixed <- replace_errors(d, le)
summary(confront(d_fixed, rules))

## -----------------------------------------------------------------------------
d_fixed

## -----------------------------------------------------------------------------
set.seed(1) # good practice, although not needed in this example
weight <- c(age = 2, income = 1) 
le <- locate_errors(d, rules, weight)
le$errors

## -----------------------------------------------------------------------------
# duration is in seconds. 
le$duration

