/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.tsp.cube;

import internal.toolkit.base.tsp.cube.CubeRepository;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import jdplus.toolkit.base.api.timeseries.util.TsDataBuilder;
import jdplus.toolkit.base.tsp.cube.CubeConnection;
import jdplus.toolkit.base.tsp.cube.CubeId;
import jdplus.toolkit.base.tsp.cube.CubeSeries;
import jdplus.toolkit.base.tsp.cube.CubeSeriesWithData;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.AbstractIOIterator;
import nbbrd.io.WrappedIOException;
import nbbrd.io.function.IORunnable;
import org.jspecify.annotations.Nullable;

public final class TableAsCubeConnection<DATE>
implements CubeConnection {
    @NonNull
    private final Resource<DATE> resource;
    private static final Map<String, String> NO_META = Collections.emptyMap();

    @Override
    @NonNull
    public Optional<IOException> testConnection() {
        Exception result = this.resource.testConnection();
        return result != null ? Optional.of(WrappedIOException.wrap((Throwable)result)) : Optional.empty();
    }

    @Override
    @NonNull
    public CubeId getRoot() throws IOException {
        try {
            return this.resource.getRoot();
        }
        catch (Exception ex) {
            throw WrappedIOException.wrap((Throwable)ex);
        }
    }

    @Override
    @NonNull
    public Stream<CubeSeries> getAllSeries(@NonNull CubeId id) throws IOException {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        CubeRepository.checkNode(id);
        try {
            AllSeriesCursor cursor = this.resource.getAllSeriesCursor(id);
            return new AllSeriesIterator(id, cursor).asStream();
        }
        catch (Exception ex) {
            throw WrappedIOException.wrap((Throwable)ex);
        }
    }

    @Override
    @NonNull
    public Stream<CubeSeriesWithData> getAllSeriesWithData(@NonNull CubeId id) throws IOException {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        CubeRepository.checkNode(id);
        try {
            AllSeriesWithDataCursor<DATE> cursor = this.resource.getAllSeriesWithDataCursor(id);
            return new AllSeriesWithDataIterator<DATE>(id, cursor, this.resource.newBuilder()).asStream();
        }
        catch (Exception ex) {
            throw WrappedIOException.wrap((Throwable)ex);
        }
    }

    @Override
    @NonNull
    public Optional<CubeSeries> getSeries(@NonNull CubeId id) throws IOException {
        Optional<CubeSeries> optional;
        block9: {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            CubeRepository.checkLeaf(id);
            SeriesCursor cursor = this.resource.getSeriesCursor(id);
            try {
                SeriesIterator result = new SeriesIterator(id, cursor);
                Optional<CubeSeries> optional2 = optional = result.hasNextWithIO() ? Optional.of((CubeSeries)result.nextWithIO()) : Optional.empty();
                if (cursor == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (cursor != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw WrappedIOException.wrap((Throwable)ex);
                }
            }
            cursor.close();
        }
        return optional;
    }

    @Override
    @NonNull
    public Optional<CubeSeriesWithData> getSeriesWithData(@NonNull CubeId id) throws IOException {
        Optional<CubeSeriesWithData> optional;
        block9: {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            CubeRepository.checkLeaf(id);
            SeriesWithDataCursor<DATE> cursor = this.resource.getSeriesWithDataCursor(id);
            try {
                SeriesWithDataIterator<DATE> result = new SeriesWithDataIterator<DATE>(id, cursor, this.resource.newBuilder());
                Optional<CubeSeriesWithData> optional2 = optional = result.hasNextWithIO() ? Optional.of((CubeSeriesWithData)result.nextWithIO()) : Optional.empty();
                if (cursor == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (cursor != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw WrappedIOException.wrap((Throwable)ex);
                }
            }
            cursor.close();
        }
        return optional;
    }

    @Override
    @NonNull
    public Stream<CubeId> getChildren(@NonNull CubeId id) throws IOException {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        CubeRepository.checkNode(id);
        try {
            ChildrenCursor cursor = this.resource.getChildrenCursor(id);
            return new ChildrenIterator(id, cursor).asStream();
        }
        catch (Exception ex) {
            throw WrappedIOException.wrap((Throwable)ex);
        }
    }

    @Override
    @NonNull
    public String getDisplayName() throws IOException {
        try {
            return this.resource.getDisplayName();
        }
        catch (Exception ex) {
            throw WrappedIOException.wrap((Throwable)ex);
        }
    }

    @Override
    @NonNull
    public String getDisplayName(@NonNull CubeId id) throws IOException {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        try {
            return this.resource.getDisplayName(id);
        }
        catch (Exception ex) {
            throw WrappedIOException.wrap((Throwable)ex);
        }
    }

    @Override
    @NonNull
    public String getDisplayNodeName(@NonNull CubeId id) throws IOException {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        try {
            return this.resource.getDisplayNodeName(id);
        }
        catch (Exception ex) {
            throw WrappedIOException.wrap((Throwable)ex);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.resource.close();
        }
        catch (Exception ex) {
            throw WrappedIOException.wrap((Throwable)ex);
        }
    }

    @Generated
    private TableAsCubeConnection(@NonNull Resource<DATE> resource) {
        if (resource == null) {
            throw new NullPointerException("resource is marked non-null but is null");
        }
        this.resource = resource;
    }

    @Generated
    public static <DATE> @org.jspecify.annotations.NonNull TableAsCubeConnection<DATE> of(@NonNull Resource<DATE> resource) {
        if (resource == null) {
            throw new NullPointerException("resource is marked non-null but is null");
        }
        return new TableAsCubeConnection<DATE>(resource);
    }

    public static interface Resource<DATE>
    extends AutoCloseable {
        public @Nullable Exception testConnection();

        @NonNull
        public CubeId getRoot() throws Exception;

        @NonNull
        public AllSeriesCursor getAllSeriesCursor(@NonNull CubeId var1) throws Exception;

        @NonNull
        public AllSeriesWithDataCursor<DATE> getAllSeriesWithDataCursor(@NonNull CubeId var1) throws Exception;

        @NonNull
        public SeriesCursor getSeriesCursor(@NonNull CubeId var1) throws Exception;

        @NonNull
        public SeriesWithDataCursor<DATE> getSeriesWithDataCursor(@NonNull CubeId var1) throws Exception;

        @NonNull
        public ChildrenCursor getChildrenCursor(@NonNull CubeId var1) throws Exception;

        @NonNull
        public String getDisplayName() throws Exception;

        @NonNull
        public String getDisplayName(@NonNull CubeId var1) throws Exception;

        @NonNull
        public String getDisplayNodeName(@NonNull CubeId var1) throws Exception;

        @NonNull
        public TsDataBuilder<DATE> newBuilder();
    }

    public static interface AllSeriesCursor
    extends TableCursor,
    WithLabel {
        @NonNull
        public String[] getDimValues() throws Exception;
    }

    private static final class AllSeriesIterator
    extends AbstractTableIterator<CubeSeries> {
        private final CubeId parentId;
        private final AllSeriesCursor cursor;

        protected boolean moveNext() throws IOException {
            try {
                return this.cursor.nextRow();
            }
            catch (Exception ex) {
                throw WrappedIOException.wrap((Throwable)ex);
            }
        }

        protected CubeSeries get() throws IOException {
            try {
                return new CubeSeries(this.parentId.child(this.cursor.getDimValues()), this.cursor.getLabelOrNull(), NO_META);
            }
            catch (Exception ex) {
                throw WrappedIOException.wrap((Throwable)ex);
            }
        }

        @Override
        protected TableCursor getTableCursor() {
            return this.cursor;
        }

        @Generated
        public AllSeriesIterator(CubeId parentId, AllSeriesCursor cursor) {
            this.parentId = parentId;
            this.cursor = cursor;
        }
    }

    public static interface AllSeriesWithDataCursor<DATE>
    extends AllSeriesCursor,
    WithData<DATE> {
    }

    private static final class AllSeriesWithDataIterator<DATE>
    extends AbstractTableIterator<CubeSeriesWithData> {
        private final CubeId parentId;
        private final AllSeriesWithDataCursor<DATE> cursor;
        private final TsDataBuilder<DATE> data;
        private boolean first = true;
        private boolean t0 = false;
        private String[] currentId = null;
        private String currentLabel = null;

        protected boolean moveNext() throws IOException {
            try {
                if (this.first) {
                    this.t0 = this.cursor.nextRow();
                    this.first = false;
                }
                if (this.t0) {
                    this.data.clear();
                    this.currentId = this.cursor.getDimValues();
                    this.currentLabel = this.cursor.getLabelOrNull();
                    boolean t1 = true;
                    while (t1) {
                        Object period = this.cursor.getPeriodOrNull();
                        Number value = null;
                        boolean t2 = true;
                        while (t2) {
                            value = this.cursor.getValueOrNull();
                            this.t0 = this.cursor.nextRow();
                            t1 = this.t0 && Arrays.equals(this.currentId, this.cursor.getDimValues());
                            t2 = t1 && Objects.equals(period, this.cursor.getPeriodOrNull());
                        }
                        this.data.add(period, value);
                    }
                    return true;
                }
                this.currentId = null;
                this.currentLabel = null;
                return false;
            }
            catch (Exception ex) {
                throw WrappedIOException.wrap((Throwable)ex);
            }
        }

        protected CubeSeriesWithData get() {
            return new CubeSeriesWithData(this.parentId.child(this.currentId), this.currentLabel, NO_META, this.data.build());
        }

        @Override
        protected TableCursor getTableCursor() {
            return this.cursor;
        }

        @Generated
        public AllSeriesWithDataIterator(CubeId parentId, AllSeriesWithDataCursor<DATE> cursor, TsDataBuilder<DATE> data) {
            this.parentId = parentId;
            this.cursor = cursor;
            this.data = data;
        }
    }

    public static interface SeriesCursor
    extends TableCursor,
    WithLabel {
    }

    private static final class SeriesIterator
    extends AbstractTableIterator<CubeSeries> {
        private final CubeId parentId;
        private final SeriesCursor cursor;
        private String currentLabel = null;

        protected boolean moveNext() throws IOException {
            try {
                boolean t0 = this.cursor.nextRow();
                if (t0) {
                    this.currentLabel = this.cursor.getLabelOrNull();
                    return true;
                }
                this.currentLabel = null;
                return false;
            }
            catch (Exception ex) {
                throw WrappedIOException.wrap((Throwable)ex);
            }
        }

        protected CubeSeries get() {
            return new CubeSeries(this.parentId, this.currentLabel, NO_META);
        }

        @Override
        protected TableCursor getTableCursor() {
            return this.cursor;
        }

        @Generated
        public SeriesIterator(CubeId parentId, SeriesCursor cursor) {
            this.parentId = parentId;
            this.cursor = cursor;
        }
    }

    public static interface SeriesWithDataCursor<DATE>
    extends SeriesCursor,
    WithData<DATE> {
    }

    private static final class SeriesWithDataIterator<DATE>
    extends AbstractTableIterator<CubeSeriesWithData> {
        private final CubeId parentId;
        private final SeriesWithDataCursor<DATE> cursor;
        private final TsDataBuilder<DATE> data;
        private String currentLabel = null;

        protected boolean moveNext() throws IOException {
            try {
                boolean t0 = this.cursor.nextRow();
                if (t0) {
                    this.currentLabel = this.cursor.getLabelOrNull();
                    Object latestPeriod = this.cursor.getPeriodOrNull();
                    while (t0) {
                        Object period = latestPeriod;
                        Number value = null;
                        boolean t1 = true;
                        while (t1) {
                            value = this.cursor.getValueOrNull();
                            t0 = this.cursor.nextRow();
                            t1 = t0 && Objects.equals(period, latestPeriod = this.cursor.getPeriodOrNull());
                        }
                        this.data.add(period, value);
                    }
                    return true;
                }
                this.currentLabel = null;
                return false;
            }
            catch (Exception ex) {
                throw WrappedIOException.wrap((Throwable)ex);
            }
        }

        protected CubeSeriesWithData get() {
            return new CubeSeriesWithData(this.parentId, this.currentLabel, NO_META, this.data.build());
        }

        @Override
        protected TableCursor getTableCursor() {
            return this.cursor;
        }

        @Generated
        public SeriesWithDataIterator(CubeId parentId, SeriesWithDataCursor<DATE> cursor, TsDataBuilder<DATE> data) {
            this.parentId = parentId;
            this.cursor = cursor;
            this.data = data;
        }
    }

    public static interface ChildrenCursor
    extends TableCursor {
        @NonNull
        public String getChild() throws Exception;
    }

    private static final class ChildrenIterator
    extends AbstractTableIterator<CubeId> {
        private final CubeId parentId;
        private final ChildrenCursor cursor;

        protected boolean moveNext() throws IOException {
            try {
                return this.cursor.nextRow();
            }
            catch (Exception ex) {
                throw WrappedIOException.wrap((Throwable)ex);
            }
        }

        protected CubeId get() throws IOException {
            try {
                return this.parentId.child(this.cursor.getChild());
            }
            catch (Exception ex) {
                throw WrappedIOException.wrap((Throwable)ex);
            }
        }

        @Override
        protected TableCursor getTableCursor() {
            return this.cursor;
        }

        @Generated
        public ChildrenIterator(CubeId parentId, ChildrenCursor cursor) {
            this.parentId = parentId;
            this.cursor = cursor;
        }
    }

    private static abstract class AbstractTableIterator<T>
    extends AbstractIOIterator<T> {
        private AbstractTableIterator() {
        }

        protected abstract TableCursor getTableCursor();

        @NonNull
        public Stream<T> asStream() {
            return (Stream)super.asStream().onClose(IORunnable.unchecked(this::close));
        }

        private void close() throws IOException {
            try {
                this.getTableCursor().close();
            }
            catch (Exception ex) {
                throw WrappedIOException.wrap((Throwable)ex);
            }
        }
    }

    public static interface WithData<DATE> {
        public @Nullable DATE getPeriodOrNull() throws Exception;

        public @Nullable Number getValueOrNull() throws Exception;
    }

    public static interface WithLabel {
        public @Nullable String getLabelOrNull() throws Exception;
    }

    public static interface TableCursor
    extends AutoCloseable {
        public boolean nextRow() throws Exception;
    }
}

