/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x11.filter;

import java.util.ArrayList;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;
import jdplus.x13.base.api.x11.SeasonalFilterOption;
import jdplus.x13.base.core.x11.X11Context;
import jdplus.x13.base.core.x11.filter.X11TrendCycleFilterFactory;
import jdplus.x13.base.core.x11.filter.endpoints.CopyEndPoints;
import jdplus.x13.base.core.x11.filter.endpoints.CopyPeriodicEndPoints;
import lombok.Generated;

public final class DefaultSeasonalNormalizer {
    public static DoubleSeq normalize(DoubleSeq in, int nextend, X11Context context) {
        return DefaultSeasonalNormalizer.normalize(in, nextend, context, 0);
    }

    public static DoubleSeq normalize(DoubleSeq in, int nextend, X11Context context, int start) {
        ArrayList<Integer> stable_index = new ArrayList<Integer>();
        SeasonalFilterOption[] filters = context.getFinalSeasonalFilter();
        int ny_all = in.length() / context.getPeriod();
        int nyr_all = in.length() % context.getPeriod() == 0 ? ny_all : ny_all + 1;
        for (int i = 0; i < context.getPeriod(); ++i) {
            int ind = (start + i) % context.getPeriod();
            if (!SeasonalFilterOption.Stable.equals((Object)filters[i]) && ny_all >= 5 && (!SeasonalFilterOption.S3X15.equals((Object)filters[i]) || nyr_all >= 20)) continue;
            stable_index.add(ind);
        }
        int start_period_input = context.getPosition(nextend);
        SymmetricFilter filter = X11TrendCycleFilterFactory.makeTrendFilter(context.getPeriod());
        int ndrop = filter.length() / 2;
        double[] x = new double[in.length()];
        DataBlock out = DataBlock.of((double[])x, (int)ndrop, (int)(x.length - ndrop));
        filter.apply(in, (DoubleSeq.Mutable)out);
        CopyEndPoints cp = new CopyEndPoints(ndrop);
        cp.process(in, DataBlock.of((double[])x));
        if (!stable_index.isEmpty()) {
            int index = 0;
            for (int p = start_period_input; p < start_period_input + ndrop; ++p) {
                if (stable_index.contains(p % context.getPeriod())) {
                    x[index] = x[index + context.getPeriod()];
                }
                ++index;
            }
            int end_period_input = (in.length() - 1 + start_period_input) % context.getPeriod();
            index = in.length() - 1;
            for (int p = end_period_input; p > end_period_input - ndrop; --p) {
                if (stable_index.contains((ndrop * context.getPeriod() + p) % context.getPeriod())) {
                    x[index] = x[index - context.getPeriod()];
                }
                --index;
            }
        }
        DoubleSeq t = DoubleSeq.of((double[])x);
        DoubleSeq tmp = context.remove(in, t);
        if (nextend == 0) {
            return tmp;
        }
        x = new double[x.length + 2 * nextend];
        tmp.copyTo(x, nextend);
        CopyPeriodicEndPoints cpp = new CopyPeriodicEndPoints(nextend, context.getPeriod());
        cpp.process(null, DataBlock.of((double[])x));
        return DoubleSeq.of((double[])x);
    }

    @Generated
    private DefaultSeasonalNormalizer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

