/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.internal.io.text;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class DateFormats {
    private static final int NO_INDEX = -1;

    private DateFormats() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static @Nullable Date parseOrNull(@NonNull DateFormat format, @NonNull CharSequence input) {
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        String source = input.toString();
        ParsePosition pos = new ParsePosition(0);
        Date result = format.parse(source, pos);
        return pos.getIndex() == input.length() ? result : null;
    }

    @NonNull
    public static CharSequence normalize(@NonNull DateFormat format, @NonNull CharSequence input) {
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return format instanceof SimpleDateFormat ? DateFormats.normalizeSimpleDateFormat((SimpleDateFormat)format, input) : input;
    }

    private static CharSequence normalizeSimpleDateFormat(SimpleDateFormat format, CharSequence input) {
        char amPmPrefix = DateFormats.getAmPmPrefix(format);
        return Character.isSpaceChar(amPmPrefix) ? DateFormats.replaceAmPmPrefixSpaceChar(format, input, amPmPrefix) : input;
    }

    private static CharSequence replaceAmPmPrefixSpaceChar(SimpleDateFormat format, CharSequence input, char amPmPrefix) {
        int amPmIndex = DateFormats.indexOfAmPm(format.getDateFormatSymbols(), input);
        if (amPmIndex <= 0 || !DateFormats.hasAmPmPrefix(input, amPmIndex)) {
            return input;
        }
        return new StringBuilder().append(input, 0, amPmIndex - 1).append(amPmPrefix).append(input, amPmIndex, input.length()).toString();
    }

    static char getAmPmPrefix(SimpleDateFormat format) {
        String pattern = format.toPattern();
        for (int i = 0; i < pattern.length() - 1; ++i) {
            char c = pattern.charAt(i);
            if (!Character.isSpaceChar(c) || pattern.charAt(i + 1) != 'a') continue;
            return c;
        }
        return '\u0000';
    }

    private static int indexOfAmPm(DateFormatSymbols symbols, CharSequence input) {
        String inputAsString = input.toString();
        for (String amPmString : symbols.getAmPmStrings()) {
            int index = inputAsString.indexOf(amPmString);
            if (index == -1) continue;
            return index;
        }
        return -1;
    }

    private static boolean hasAmPmPrefix(CharSequence input, int amPmIndex) {
        return Character.isSpaceChar(input.charAt(amPmIndex - 1));
    }
}

