/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.text;

import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.text.BaseProperty;
import nbbrd.io.text.Formatter;
import nbbrd.io.text.Parser;
import org.jspecify.annotations.Nullable;

public final class Property<T>
extends BaseProperty {
    @NonNull
    private final String key;
    private final @Nullable T defaultValue;
    @NonNull
    private final Parser<T> parser;
    @NonNull
    private final Formatter<T> formatter;

    public @Nullable T get(@NonNull Function<? super String, ? extends CharSequence> properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        CharSequence value = properties.apply(this.key);
        if (value == null) {
            return this.defaultValue;
        }
        T result = this.parser.parse(value);
        return result != null ? result : this.defaultValue;
    }

    public @Nullable T get(@NonNull Properties properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        return this.get(properties::getProperty);
    }

    public @Nullable T get(@NonNull Map<String, String> properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        return this.get(properties::get);
    }

    public void set(@NonNull BiConsumer<? super String, ? super String> properties, @Nullable T value) {
        String valueAsString;
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        if (!Objects.equals(value, this.defaultValue) && (valueAsString = this.formatter.formatAsString(value)) != null) {
            properties.accept(this.key, valueAsString);
        }
    }

    public void set(@NonNull Properties properties, T value) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.set(properties::setProperty, value);
    }

    public void set(@NonNull Map<String, String> properties, T value) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.set(properties::put, value);
    }

    @Generated
    private Property(@NonNull String key, @Nullable T defaultValue, @NonNull Parser<T> parser, @NonNull Formatter<T> formatter) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (parser == null) {
            throw new NullPointerException("parser is marked non-null but is null");
        }
        if (formatter == null) {
            throw new NullPointerException("formatter is marked non-null but is null");
        }
        this.key = key;
        this.defaultValue = defaultValue;
        this.parser = parser;
        this.formatter = formatter;
    }

    @Generated
    public static <T> @org.jspecify.annotations.NonNull Property<T> of(@NonNull String key, @Nullable T defaultValue, @NonNull Parser<T> parser, @NonNull Formatter<T> formatter) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (parser == null) {
            throw new NullPointerException("parser is marked non-null but is null");
        }
        if (formatter == null) {
            throw new NullPointerException("formatter is marked non-null but is null");
        }
        return new Property<T>(key, defaultValue, parser, formatter);
    }

    @Override
    @NonNull
    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public @Nullable T getDefaultValue() {
        return this.defaultValue;
    }
}

