/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import jdplus.toolkit.base.api.timeseries.TimePoint;
import jdplus.toolkit.base.api.timeseries.TimeSelector;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class DiscreteTimeDomain
implements TimeSeriesDomain<TimePoint> {
    @NonNull
    private final LocalDateTime[] timestamps;

    @Override
    public int length() {
        return this.timestamps.length;
    }

    @Override
    public TimePoint get(int index) throws IndexOutOfBoundsException {
        return TimePoint.of(this.timestamps[index]);
    }

    @Override
    public LocalDateTime start() {
        return this.timestamps[0];
    }

    @Override
    public LocalDateTime end() {
        return this.timestamps[this.timestamps.length - 1].plusNanos(1L);
    }

    @Override
    public boolean contains(LocalDateTime date) {
        return Arrays.binarySearch(this.timestamps, date) >= 0;
    }

    @Override
    public int indexOf(LocalDateTime date) {
        return Arrays.binarySearch(this.timestamps, date);
    }

    public static DiscreteTimeDomain of(List<LocalDateTime> values) {
        return DiscreteTimeDomain.of(values.toArray(new LocalDateTime[values.size()]));
    }

    @Override
    public int indexOf(TimePoint point) {
        return Arrays.binarySearch(this.timestamps, point.start());
    }

    @Override
    public boolean contains(TimePoint period) {
        return Arrays.binarySearch(this.timestamps, period.start()) >= 0;
    }

    @Override
    public Iterator<TimePoint> iterator() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public TimeSeriesDomain<TimePoint> select(TimeSelector selector) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Generated
    private DiscreteTimeDomain(@NonNull LocalDateTime[] timestamps) {
        if (timestamps == null) {
            throw new NullPointerException("timestamps is marked non-null but is null");
        }
        this.timestamps = timestamps;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull DiscreteTimeDomain of(@NonNull LocalDateTime[] timestamps) {
        if (timestamps == null) {
            throw new NullPointerException("timestamps is marked non-null but is null");
        }
        return new DiscreteTimeDomain(timestamps);
    }

    @NonNull
    @Generated
    public LocalDateTime[] getTimestamps() {
        return this.timestamps;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DiscreteTimeDomain)) {
            return false;
        }
        DiscreteTimeDomain other = (DiscreteTimeDomain)o;
        return Arrays.deepEquals(this.getTimestamps(), other.getTimestamps());
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getTimestamps());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "DiscreteTimeDomain(timestamps=" + Arrays.deepToString(this.getTimestamps()) + ")";
    }
}

