/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.api.seats;

import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import jdplus.tramoseats.base.api.seats.Seats;

public final class SeatsLoader {

    public static final class Processor {
        private final Iterable<Seats.Processor> source = ServiceLoader.load(Seats.Processor.class);
        private final AtomicReference<Seats.Processor> resource = new AtomicReference<Seats.Processor>(this.doLoad());
        private final Consumer<Iterable> cleaner = loader -> ((ServiceLoader)loader).reload();

        private Seats.Processor doLoad() {
            return StreamSupport.stream(this.source.spliterator(), false).findFirst().orElseGet(() -> new Seats.DefProcessor());
        }

        public Seats.Processor get() {
            return this.resource.get();
        }

        public void set(Seats.Processor newValue) {
            this.resource.set(Objects.requireNonNull(newValue));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reload() {
            Iterable<Seats.Processor> iterable = this.source;
            synchronized (iterable) {
                this.cleaner.accept(this.source);
                this.set(this.doLoad());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            Iterable<Seats.Processor> iterable = this.source;
            synchronized (iterable) {
                this.set(this.doLoad());
            }
        }
    }
}

