/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.protobuf;

import jdplus.x13.base.api.x11.SeasonalFilterOption;
import jdplus.x13.base.api.x11.SigmaVecOption;
import jdplus.x13.base.api.x11.X11Spec;
import jdplus.x13.base.protobuf.X11Spec;
import jdplus.x13.base.protobuf.X13ProtosUtility;
import lombok.Generated;

public final class X11Proto {
    public static void fill(jdplus.x13.base.api.x11.X11Spec spec, X11Spec.Builder builder) {
        builder.setMode(X13ProtosUtility.convert(spec.getMode())).setSeasonal(spec.isSeasonal()).setLsig(spec.getLowerSigma()).setUsig(spec.getUpperSigma()).setHenderson(spec.getHendersonFilterLength()).setNfcasts(spec.getForecastHorizon()).setNbcasts(spec.getBackcastHorizon()).setSigma(X13ProtosUtility.convert(spec.getCalendarSigma())).setExcludeFcasts(spec.isExcludeForecast()).setBias(X13ProtosUtility.convert(spec.getBias()));
        SeasonalFilterOption[] filters = spec.getFilters();
        for (int i = 0; i < filters.length; ++i) {
            builder.addSfilters(X13ProtosUtility.convert(filters[i]));
        }
        SigmaVecOption[] vs = spec.getSigmaVec();
        if (vs != null) {
            for (int i = 0; i < vs.length; ++i) {
                builder.addVsigmas(vs[i] == SigmaVecOption.Group1 ? 1 : 2);
            }
        }
    }

    public static X11Spec convert(jdplus.x13.base.api.x11.X11Spec spec) {
        X11Spec.Builder builder = X11Spec.newBuilder();
        X11Proto.fill(spec, builder);
        return builder.build();
    }

    public static jdplus.x13.base.api.x11.X11Spec convert(X11Spec x11) {
        int i;
        X11Spec.Builder builder = jdplus.x13.base.api.x11.X11Spec.builder().mode(X13ProtosUtility.convert(x11.getMode())).seasonal(x11.getSeasonal()).lowerSigma(x11.getLsig()).upperSigma(x11.getUsig()).hendersonFilterLength(x11.getHenderson()).forecastHorizon(x11.getNfcasts()).backcastHorizon(x11.getNbcasts()).calendarSigma(X13ProtosUtility.convert(x11.getSigma())).excludeForecast(x11.getExcludeFcasts()).bias(X13ProtosUtility.convert(x11.getBias()));
        int n = x11.getSfiltersCount();
        if (n > 0) {
            SeasonalFilterOption[] sf = new SeasonalFilterOption[n];
            for (i = 0; i < n; ++i) {
                sf[i] = X13ProtosUtility.convert(x11.getSfilters(i));
            }
            builder.filters(sf);
        }
        if ((n = x11.getVsigmasCount()) > 0) {
            SigmaVecOption[] sv = new SigmaVecOption[n];
            for (i = 0; i < n; ++i) {
                sv[i] = x11.getVsigmas(i) == 1 ? SigmaVecOption.Group1 : SigmaVecOption.Group2;
            }
            builder.sigmaVec(sv);
        }
        return (jdplus.x13.base.api.x11.X11Spec)builder.build();
    }

    @Generated
    private X11Proto() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

