/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.functions;

import java.io.Serializable;
import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.functions.MathFunctionWithDerivative;
import umontreal.iro.lecuyer.functions.MathFunctionWithFirstDerivative;
import umontreal.iro.lecuyer.functions.MathFunctionWithIntegral;
import umontreal.iro.lecuyer.util.PrintfFormat;

public class Polynomial
implements MathFunction,
MathFunctionWithFirstDerivative,
MathFunctionWithDerivative,
MathFunctionWithIntegral,
Serializable,
Cloneable {
    private static final long serialVersionUID = -2911550952861456470L;
    private double[] coeff;

    public Polynomial(double ... dArray) {
        if (dArray == null) {
            throw new NullPointerException();
        }
        if (dArray.length == 0) {
            throw new IllegalArgumentException("At least one coefficient is needed");
        }
        this.coeff = (double[])dArray.clone();
    }

    public int getDegree() {
        return this.coeff.length - 1;
    }

    public double[] getCoefficients() {
        return (double[])this.coeff.clone();
    }

    public double getCoefficient(int n) {
        return this.coeff[n];
    }

    public void setCoefficients(double ... dArray) {
        if (dArray == null) {
            throw new NullPointerException();
        }
        if (dArray.length == 0) {
            throw new IllegalArgumentException("At least one coefficient is needed");
        }
        this.coeff = (double[])dArray.clone();
    }

    public double evaluate(double d) {
        double d2 = this.coeff[this.coeff.length - 1];
        for (int i = this.coeff.length - 2; i >= 0; --i) {
            d2 = this.coeff[i] + d * d2;
        }
        return d2;
    }

    public double derivative(double d) {
        return this.derivative(d, 1);
    }

    public double derivative(double d, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (n == 0) {
            return this.evaluate(d);
        }
        if (n >= this.coeff.length) {
            return 0.0;
        }
        double d2 = this.getCoeffDer(this.coeff.length - 1, n);
        for (int i = this.coeff.length - 2; i >= n; --i) {
            d2 = this.getCoeffDer(i, n) + d * d2;
        }
        return d2;
    }

    public Polynomial derivativePolynomial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (n == 0) {
            return this;
        }
        if (n >= this.coeff.length) {
            return new Polynomial(0.0);
        }
        double[] dArray = new double[this.coeff.length - n];
        for (int i = this.coeff.length - 1; i >= n; --i) {
            dArray[i - n] = this.getCoeffDer(i, n);
        }
        return new Polynomial(dArray);
    }

    private double getCoeffDer(int n, int n2) {
        double d = this.coeff[n];
        for (int i = n; i > n - n2; --i) {
            d *= (double)i;
        }
        return d;
    }

    public double integral(double d, double d2) {
        return this.integralA0(d2) - this.integralA0(d);
    }

    private double integralA0(double d) {
        int n = this.coeff.length - 1;
        double d2 = d * this.coeff[n] / (double)(n + 1);
        for (int i = this.coeff.length - 2; i >= 0; --i) {
            d2 = this.coeff[i] * d / (double)(i + 1) + d * d2;
        }
        return d2;
    }

    public Polynomial integralPolynomial(double d) {
        double[] dArray = new double[this.coeff.length + 1];
        dArray[0] = d;
        for (int i = 0; i < this.coeff.length; ++i) {
            dArray[i + 1] = this.coeff[i] / (double)(i + 1);
        }
        return new Polynomial(dArray);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.coeff.length; ++i) {
            if (i > 0) {
                if (this.coeff[i] == 0.0) continue;
                if (this.coeff[i] > 0.0) {
                    stringBuilder.append(" + ");
                } else {
                    stringBuilder.append(" - ");
                }
                stringBuilder.append(PrintfFormat.format(8, 3, 3, Math.abs(this.coeff[i])));
            } else {
                stringBuilder.append(PrintfFormat.format(8, 3, 3, this.coeff[i]));
            }
            if (i <= 0) continue;
            stringBuilder.append("*X");
            if (i <= 1) continue;
            stringBuilder.append("^").append(i);
        }
        return stringBuilder.toString();
    }

    public Polynomial clone() {
        Polynomial polynomial;
        try {
            polynomial = (Polynomial)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Clone not supported");
        }
        polynomial.coeff = (double[])this.coeff.clone();
        return polynomial;
    }
}

