/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simevents;

import umontreal.iro.lecuyer.simevents.Simulator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Event
implements Comparable<Event> {
    protected Simulator sim;
    protected double priority;
    protected double eventTime;

    public Event() {
        this(Simulator.getDefaultSimulator());
    }

    public Event(Simulator simulator) {
        if (simulator == null) {
            throw new NullPointerException();
        }
        this.eventTime = -10.0;
        this.priority = 1.0;
        this.sim = simulator;
    }

    public void schedule(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Cannot schedule in the past.");
        }
        if (this.eventTime > -1.0) {
            throw new IllegalStateException("Event already scheduled");
        }
        this.eventTime = this.sim.time() + d;
        this.sim.eventList.add(this);
    }

    public void scheduleNext() {
        if (this.eventTime > -1.0) {
            throw new IllegalStateException("Event already scheduled");
        }
        this.eventTime = this.sim.time();
        this.priority = 0.0;
        this.sim.eventList.addFirst(this);
    }

    public void scheduleBefore(Event event) {
        if (this.eventTime > -1.0) {
            throw new IllegalStateException("Event already scheduled");
        }
        this.eventTime = event.eventTime;
        this.priority = event.priority;
        this.sim.eventList.addBefore(this, event);
    }

    public void scheduleAfter(Event event) {
        if (this.eventTime > -1.0) {
            throw new IllegalStateException("Event already scheduled");
        }
        this.eventTime = event.eventTime;
        this.priority = event.priority;
        this.sim.eventList.addAfter(this, event);
    }

    public void reschedule(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Cannot schedule in the past.");
        }
        if (this.eventTime < -1.0) {
            throw new IllegalStateException("Event not scheduled");
        }
        this.sim.getEventList().remove(this);
        this.eventTime = this.sim.time() + d;
        this.sim.getEventList().add(this);
    }

    public boolean cancel() {
        boolean bl = false;
        if (this.eventTime >= this.sim.time()) {
            bl = this.sim.getEventList().remove(this);
        }
        this.eventTime = -10.0;
        return bl;
    }

    public final boolean cancel(String string) {
        Event event = this.sim.getEventList().getFirstOfClass(string);
        return event.cancel();
    }

    public final Simulator simulator() {
        return this.sim;
    }

    public final void setSimulator(Simulator simulator) {
        if (simulator == null) {
            throw new NullPointerException();
        }
        if (this.eventTime > -1.0) {
            throw new UnsupportedOperationException("Unable to set Simulator, current Event already scheduled");
        }
        this.sim = simulator;
    }

    public final double time() {
        return this.eventTime;
    }

    public final void setTime(double d) {
        if (this.eventTime > -1.0) {
            throw new UnsupportedOperationException("Unable to set time, current Event already scheduled");
        }
        this.eventTime = d;
    }

    public final double priority() {
        return this.priority;
    }

    public final void setPriority(double d) {
        if (this.eventTime > -1.0) {
            throw new UnsupportedOperationException("Unable to set priority, current Event already scheduled");
        }
        this.priority = d;
    }

    @Override
    public int compareTo(Event event) {
        if (this.eventTime < event.time()) {
            return -1;
        }
        if (this.eventTime > event.time()) {
            return 1;
        }
        if (this.priority < event.priority()) {
            return -1;
        }
        if (this.priority < event.priority()) {
            return 1;
        }
        return 0;
    }

    public abstract void actions();
}

