/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst.semi_supervised.constraints;

import cc.mallet.fst.SumLattice;
import cc.mallet.fst.semi_supervised.StateLabelMap;
import cc.mallet.fst.semi_supervised.constraints.GEConstraint;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.FeatureVectorSequence;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntIntHashMap;
import com.carrotsearch.hppc.cursors.IntIntCursor;
import java.util.ArrayList;
import java.util.BitSet;

public abstract class TwoLabelGEConstraints
implements GEConstraint {
    protected ArrayList<TwoLabelGEConstraint> constraintsList;
    protected IntIntHashMap constraintsMap;
    protected StateLabelMap map;
    protected IntArrayList cache;

    public TwoLabelGEConstraints() {
        this.constraintsList = new ArrayList();
        this.constraintsMap = new IntIntHashMap();
        this.map = null;
        this.cache = new IntArrayList();
    }

    protected TwoLabelGEConstraints(ArrayList<TwoLabelGEConstraint> constraintsList, IntIntHashMap constraintsMap, StateLabelMap map) {
        this.constraintsList = constraintsList;
        this.constraintsMap = constraintsMap;
        this.map = map;
        this.cache = new IntArrayList();
    }

    public abstract void addConstraint(int var1, double[][] var2, double var3);

    @Override
    public boolean isOneStateConstraint() {
        return false;
    }

    @Override
    public void setStateLabelMap(StateLabelMap map) {
        this.map = map;
    }

    @Override
    public void preProcess(FeatureVector fv) {
        this.cache.clear();
        for (int loc = 0; loc < fv.numLocations(); ++loc) {
            int fi = fv.indexAtLocation(loc);
            if (!this.constraintsMap.containsKey(fi)) continue;
            this.cache.add(this.constraintsMap.get(fi));
        }
    }

    @Override
    public BitSet preProcess(InstanceList data) {
        BitSet bitSet = new BitSet(data.size());
        int ii = 0;
        for (Instance instance : data) {
            FeatureVectorSequence fvs = (FeatureVectorSequence)instance.getData();
            for (int ip = 1; ip < fvs.size(); ++ip) {
                for (IntIntCursor keyVal : this.constraintsMap) {
                    if (fvs.get(ip).location(keyVal.key) < 0) continue;
                    this.constraintsList.get((int)keyVal.value).count += 1.0;
                    bitSet.set(ii);
                }
            }
            ++ii;
        }
        return bitSet;
    }

    @Override
    public double getCompositeConstraintFeatureValue(FeatureVector fv, int ip, int si1, int si2) {
        if (ip == 0) {
            return 0.0;
        }
        double value = 0.0;
        int li1 = this.map.getLabelIndex(si1);
        if (li1 == -2) {
            return 0.0;
        }
        int li2 = this.map.getLabelIndex(si2);
        for (int i = 0; i < this.cache.size(); ++i) {
            value += this.constraintsList.get(this.cache.get(i)).getValue(li1, li2);
        }
        return value;
    }

    @Override
    public abstract double getValue();

    @Override
    public void zeroExpectations() {
        for (TwoLabelGEConstraint constraint : this.constraintsList) {
            constraint.expectation = new double[this.map.getNumLabels()][this.map.getNumLabels()];
        }
    }

    @Override
    public void computeExpectations(ArrayList<SumLattice> lattices) {
        IntArrayList cache = new IntArrayList();
        for (int i = 0; i < lattices.size(); ++i) {
            if (lattices.get(i) == null) continue;
            FeatureVectorSequence fvs = (FeatureVectorSequence)lattices.get(i).getInput();
            SumLattice lattice = lattices.get(i);
            double[][][] xis = lattice.getXis();
            for (int ip = 1; ip < fvs.size(); ++ip) {
                cache.clear();
                FeatureVector fv = fvs.getFeatureVector(ip);
                for (int loc = 0; loc < fv.numLocations(); ++loc) {
                    int fi = fv.indexAtLocation(loc);
                    if (!this.constraintsMap.containsKey(fi)) continue;
                    cache.add(this.constraintsMap.get(fi));
                }
                for (int prev = 0; prev < this.map.getNumStates(); ++prev) {
                    int liPrev = this.map.getLabelIndex(prev);
                    if (liPrev == -2) continue;
                    for (int curr = 0; curr < this.map.getNumStates(); ++curr) {
                        int liCurr = this.map.getLabelIndex(curr);
                        if (liCurr == -2) continue;
                        double prob = Math.exp(xis[ip][prev][curr]);
                        for (int j = 0; j < cache.size(); ++j) {
                            double[] dArray = this.constraintsList.get((int)cache.get((int)j)).expectation[liPrev];
                            int n = liCurr;
                            dArray[n] = dArray[n] + prob;
                        }
                    }
                }
            }
        }
    }

    protected abstract class TwoLabelGEConstraint {
        protected double[][] target;
        protected double[][] expectation;
        protected double count;
        protected double weight;

        public TwoLabelGEConstraint(double[][] target, double weight) {
            this.target = target;
            this.weight = weight;
            this.expectation = null;
            this.count = 0.0;
        }

        public abstract double getValue(int var1, int var2);
    }
}

