/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1.data;

import eu.kliegr.ac1.data.AttributeType;
import eu.kliegr.ac1.data.AttributeValue;
import eu.kliegr.ac1.data.AttributeValueType;
import eu.kliegr.ac1.data.Transaction;
import eu.kliegr.ac1.rule.parsers.ArulesParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Logger;

public class Attribute {
    private static final Logger LOGGER = Logger.getLogger(Attribute.class.getName());
    private final String name;
    private final ConcurrentSkipListMap attributeValues = new ConcurrentSkipListMap();
    private final ConcurrentSkipListMap breakpointAttributeValues = new ConcurrentSkipListMap();
    public final int AID;
    final boolean isTargetAttribute;
    private final AttributeType type;
    final boolean isIDAttribute;

    public static Attribute makeAttribute(String name, boolean target, AttributeType type, boolean IDcolumn, int AID) {
        Attribute a = new Attribute(name, AID, target, type, IDcolumn);
        return a;
    }

    protected Attribute(String name, int AID, boolean target, AttributeType type, boolean IDcolumnFlag) {
        this.type = type;
        if (name == null) {
            name = "#A" + AID;
        }
        this.name = name;
        this.AID = AID;
        this.isTargetAttribute = target;
        this.isIDAttribute = IDcolumnFlag;
    }

    public String getName() {
        return this.name;
    }

    public AttributeType getType() {
        return this.type;
    }

    public int getNumberOfValuesWithMinSupport(int minSupp) {
        int total = 0;
        total = this.getAllValues().stream().filter(val -> val.getTransactions().size() >= minSupp).map(_item -> 1).reduce(total, Integer::sum);
        return total;
    }

    public ArrayList<Integer> getNumberOfValuesWithSupport() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        this.getAllValues().stream().forEach(val -> list.add(val.getTransactions().size()));
        return list;
    }

    public AttributeValue getValueByString(String value) {
        if (this.type == AttributeType.numerical) {
            if (value.isEmpty() | value == null) {
                return (AttributeValue)this.attributeValues.get(Float.valueOf(Float.NaN));
            }
            return (AttributeValue)this.attributeValues.get(Float.valueOf(Float.parseFloat(ArulesParser.normInfinity(value))));
        }
        if (value == null) {
            LOGGER.warning("Passed null value converted to empty string");
            value = "";
        }
        return (AttributeValue)this.attributeValues.get(value);
    }

    public AttributeValue getAdjacentHigher(AttributeValue value) {
        return this.getAdjacentHigher(value, false);
    }

    public AttributeValue getAdjacentHigher(AttributeValue value, boolean requireBreakpoint) {
        ConcurrentSkipListMap map;
        ConcurrentSkipListMap concurrentSkipListMap = map = requireBreakpoint ? this.breakpointAttributeValues : this.attributeValues;
        if (this.type == AttributeType.numerical) {
            Map.Entry e = map.higherEntry(Float.valueOf(Float.parseFloat(value.value)));
            if (e == null) {
                return null;
            }
            if (e.getKey().equals(Float.valueOf(Float.NaN))) {
                return null;
            }
            return (AttributeValue)e.getValue();
        }
        throw new UnsupportedOperationException("nominal attributes not yet suppported");
    }

    public AttributeValue getAdjacentLower(AttributeValue value) {
        return this.getAdjacentLower(value, false);
    }

    public AttributeValue getAdjacentLower(AttributeValue value, boolean requireBreakpoint) {
        ConcurrentSkipListMap map;
        ConcurrentSkipListMap concurrentSkipListMap = map = requireBreakpoint ? this.breakpointAttributeValues : this.attributeValues;
        if (this.type == AttributeType.numerical) {
            Map.Entry e = map.lowerEntry(Float.valueOf(Float.parseFloat(value.value)));
            if (e == null) {
                return null;
            }
            return (AttributeValue)e.getValue();
        }
        throw new UnsupportedOperationException("nominal attributes not yet suppported");
    }

    public Collection<AttributeValue> getValuesInRange(Float fromKey, boolean fromInclusive, Float toKey, boolean toInclusive) {
        return this.attributeValues.subMap(fromKey, fromInclusive, toKey, toInclusive).values();
    }

    public Collection<AttributeValue> getAllValues() {
        ArrayList<AttributeValue> copy = new ArrayList<AttributeValue>(this.attributeValues.values());
        return copy;
    }

    public void setAttributeValueAsBreakpoint(AttributeValue val) {
        if (this.type == AttributeType.numerical) {
            this.breakpointAttributeValues.put(val.getNumericalValue(), val);
        } else {
            this.breakpointAttributeValues.put(val.value, val);
        }
    }

    public AttributeValue addNewValue(String value, Transaction TID, AttributeValueType attValtype) {
        if (TID == null && attValtype == AttributeValueType.dataBacked) {
            throw new UnsupportedOperationException("TID can be null only for breakpoint values");
        }
        AttributeValue val = new AttributeValue(value, this, attValtype);
        if (TID != null) {
            val.addTransaction(TID, true);
        }
        if (this.type == AttributeType.numerical) {
            this.attributeValues.put(val.getNumericalValue(), val);
        } else {
            this.attributeValues.put(val.value, val);
        }
        if (attValtype == AttributeValueType.breakpoint || attValtype == AttributeValueType.dataBackedbreakpoint) {
            this.setAttributeValueAsBreakpoint(val);
        }
        return val;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ATTRIBUTE:");
        sb.append(this.name);
        Collection values = this.attributeValues.values();
        values.stream().map(at -> {
            sb.append("\n#VALUE:");
            sb.append(at.value);
            return at;
        }).forEach(at -> {
            sb.append("\n##transactions:");
            at.transactions.stream().map(t -> String.valueOf(t.internalTID)).reduce((t, t2) -> t + "," + t2).ifPresent(transAsString -> sb.append((String)transAsString));
        });
        return sb.toString();
    }
}

