/*
 * Decompiled with CFR 0.152.
 */
package jdplus.text.base.r;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import jdplus.text.base.api.XmlBean;
import jdplus.text.base.api.XmlProvider;
import jdplus.toolkit.base.api.timeseries.Ts;
import jdplus.toolkit.base.api.timeseries.TsCollection;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsFactory;
import jdplus.toolkit.base.api.timeseries.TsInformationType;
import jdplus.toolkit.base.api.timeseries.TsMoniker;
import jdplus.toolkit.base.tsp.DataSet;
import jdplus.toolkit.base.tsp.DataSource;
import lombok.Generated;

public final class XmlFiles {
    private static final XmlProvider PROVIDER = new XmlProvider();

    static XmlProvider currentProvider() {
        return TsFactory.getDefault().getProvider("Xml").orElse(null);
    }

    public static String changeFile(String id, String nfile, String ofile) {
        Optional set = PROVIDER.toDataSet(TsMoniker.of((String)"Xml", (String)id));
        Optional<String> m = set.map(d -> {
            XmlBean bean = PROVIDER.decodeBean(d.getDataSource());
            if (ofile.isBlank() || bean.getFile().getName().equals(ofile)) {
                bean.setFile(Path.of(nfile, new String[0]).toFile());
                DataSource src = PROVIDER.encodeBean((Object)bean);
                DataSet nd = d.toBuilder().dataSource(src).build();
                return PROVIDER.toMoniker(nd).getId();
            }
            return id;
        });
        return m.orElse(id);
    }

    public static DataSource source(String file, String cs) {
        XmlBean bean = new XmlBean();
        bean.setFile(Path.of(file, new String[0]).toFile());
        if (!cs.isEmpty()) {
            Charset charset = Charset.forName(cs);
            bean.setCharset(charset);
        }
        return PROVIDER.encodeBean((Object)bean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] sheets(DataSource source) throws Exception {
        XmlProvider currentProvider = XmlFiles.currentProvider();
        if (currentProvider == null) {
            throw new Exception("XmlProvider is not available");
        }
        try {
            currentProvider.open(source);
            List sheets = currentProvider.children(source);
            String[] stringArray = (String[])sheets.stream().map(s -> currentProvider.getDisplayNodeName(s)).toArray(String[]::new);
            return stringArray;
        }
        finally {
            currentProvider.close(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] series(DataSource source, int sheet) throws Exception {
        XmlProvider currentProvider = XmlFiles.currentProvider();
        if (currentProvider == null) {
            throw new Exception("XmlProvider is not available");
        }
        try {
            currentProvider.open(source);
            List sheets = currentProvider.children(source);
            if (sheet > sheets.size()) {
                throw new IllegalArgumentException("Invalid sheet");
            }
            DataSet ds = (DataSet)sheets.get(sheet - 1);
            List all = currentProvider.children(ds);
            String[] stringArray = (String[])all.stream().map(s -> currentProvider.getDisplayNodeName(s)).toArray(String[]::new);
            return stringArray;
        }
        finally {
            currentProvider.close(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Ts series(DataSource source, int sheet, int series, boolean fullName) throws Exception {
        XmlProvider currentProvider = XmlFiles.currentProvider();
        if (currentProvider == null) {
            throw new Exception("XmlProvider is not available");
        }
        try {
            currentProvider.open(source);
            List sheets = currentProvider.children(source);
            if (sheet > sheets.size()) {
                throw new IllegalArgumentException("Invalid sheet");
            }
            DataSet ds = (DataSet)sheets.get(sheet - 1);
            List all = currentProvider.children(ds);
            if (series > all.size()) {
                throw new IllegalArgumentException("Invalid sheet");
            }
            DataSet s = (DataSet)all.get(series - 1);
            TsMoniker moniker = currentProvider.toMoniker(s);
            Ts ts = currentProvider.getTs(moniker, TsInformationType.All).withName(fullName ? currentProvider.getDisplayName(s) : currentProvider.getDisplayNodeName(s));
            return ts;
        }
        finally {
            currentProvider.close(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TsCollection collection(DataSource source, int sheet, boolean fullNames) throws Exception {
        XmlProvider currentProvider = XmlFiles.currentProvider();
        if (currentProvider == null) {
            throw new Exception("XmlProvider is not available");
        }
        try {
            currentProvider.open(source);
            List sheets = currentProvider.children(source);
            if (sheet > sheets.size()) {
                throw new IllegalArgumentException("Invalid sheet");
            }
            DataSet ds = (DataSet)sheets.get(sheet - 1);
            TsMoniker moniker = currentProvider.toMoniker(ds);
            if (fullNames) {
                TsCollection tsCollection = currentProvider.getTsCollection(moniker, TsInformationType.All).withName(currentProvider.getDisplayName(ds));
                return tsCollection;
            }
            List schildren = currentProvider.children(ds);
            List<Ts> all = schildren.stream().map(c -> XmlFiles.of(currentProvider, c)).toList();
            TsCollection tsCollection = TsCollection.builder().name(currentProvider.getDisplayName(ds)).moniker(moniker).items(all).build();
            return tsCollection;
        }
        finally {
            currentProvider.close(source);
        }
    }

    private static Ts of(XmlProvider provider, DataSet c) {
        TsMoniker moniker = provider.toMoniker(c);
        try {
            return provider.getTs(moniker, TsInformationType.All).withName(provider.getDisplayNodeName(c));
        }
        catch (IOException ex) {
            return Ts.builder().moniker(moniker).data(TsData.empty((String)"Unavailable")).build();
        }
    }

    public static void setPaths(String[] paths) throws Exception {
        XmlProvider provider = XmlFiles.currentProvider();
        if (provider == null) {
            throw new Exception("XmlProvider is not available");
        }
        File[] files = (File[])Arrays.stream(paths).map(p -> Path.of(p, new String[0]).toFile()).toArray(File[]::new);
        provider.setPaths(files);
    }

    public static DataSet decode(String id) {
        Optional set = PROVIDER.toDataSet(TsMoniker.of((String)"Xml", (String)id));
        return set.orElse(null);
    }

    public static String encode(DataSet set) {
        return PROVIDER.toMoniker(set).getId();
    }

    public static XmlBean sourceOf(DataSet set) {
        return PROVIDER.decodeBean(set.getDataSource());
    }

    public static DataSet seriesDataSet(DataSource source, int collectionIndex, int seriesIndex) {
        return DataSet.builder((DataSource)source, (DataSet.Kind)DataSet.Kind.SERIES).parameter("collectionIndex", Integer.toString(collectionIndex - 1)).parameter("seriesIndex", Integer.toString(seriesIndex - 1)).build();
    }

    public static DataSet sheetDataSet(DataSource source, String sheetName) {
        return DataSet.builder((DataSource)source, (DataSet.Kind)DataSet.Kind.COLLECTION).parameter("sheetName", sheetName).build();
    }

    @Generated
    private XmlFiles() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

