/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.text;

import internal.io.InternalResource;
import internal.io.text.ComposeTextFormatter;
import internal.io.text.FunctionalTextFormatter;
import internal.io.text.InternalFormatter;
import internal.io.text.InternalTextResource;
import internal.io.text.LegacyFiles;
import internal.io.text.WithCharsetFileFormatter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.NonNull;
import nbbrd.io.FileFormatter;
import nbbrd.io.Resource;
import nbbrd.io.function.IOBiConsumer;
import nbbrd.io.function.IOFunction;
import nbbrd.io.function.IOSupplier;
import nbbrd.io.text.Formatter;

public interface TextFormatter<T> {
    @NonNull
    default public String formatToString(@NonNull T value) throws IOException {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        StringWriter writer = new StringWriter();
        this.formatWriter(value, writer);
        return writer.toString();
    }

    default public void formatChars(@NonNull T value, @NonNull Appendable target) throws IOException {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        StringWriter writer = new StringWriter();
        this.formatWriter(value, writer);
        target.append(writer.getBuffer());
    }

    default public void formatFile(@NonNull T value, @NonNull File target, @NonNull Charset encoding) throws IOException {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (encoding == null) {
            throw new NullPointerException("encoding is marked non-null but is null");
        }
        try (BufferedOutputStream bufferedResource = new BufferedOutputStream(LegacyFiles.newOutputStream(target));){
            this.formatStream(value, bufferedResource, encoding);
        }
    }

    default public void formatPath(@NonNull T value, @NonNull Path target, @NonNull Charset encoding) throws IOException {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (encoding == null) {
            throw new NullPointerException("encoding is marked non-null but is null");
        }
        Optional<File> file = Resource.getFile(target);
        if (file.isPresent()) {
            this.formatFile(value, file.get(), encoding);
        } else {
            this.formatStream(value, () -> Files.newOutputStream(target, new OpenOption[0]), encoding);
        }
    }

    default public void formatWriter(@NonNull T value, @NonNull IOSupplier<? extends Writer> target) throws IOException {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        try (Writer resource = InternalTextResource.openWriter(target);){
            this.formatWriter(value, resource);
        }
    }

    default public void formatStream(@NonNull T value, @NonNull IOSupplier<? extends OutputStream> target, @NonNull Charset encoding) throws IOException {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (encoding == null) {
            throw new NullPointerException("encoding is marked non-null but is null");
        }
        try (OutputStream resource = InternalResource.openOutputStream(target);){
            this.formatStream(value, resource, encoding);
        }
    }

    public void formatWriter(@NonNull T var1, @NonNull Writer var2) throws IOException;

    public void formatStream(@NonNull T var1, @NonNull OutputStream var2, @NonNull Charset var3) throws IOException;

    @NonNull
    default public <V> TextFormatter<V> compose(@NonNull IOFunction<? super V, ? extends T> before) {
        if (before == null) {
            throw new NullPointerException("before is marked non-null but is null");
        }
        return new ComposeTextFormatter<V, T>(this, before);
    }

    @NonNull
    default public FileFormatter<T> asFileFormatter(@NonNull Charset encoding) {
        if (encoding == null) {
            throw new NullPointerException("encoding is marked non-null but is null");
        }
        return new WithCharsetFileFormatter(this, encoding);
    }

    @NonNull
    default public Formatter<T> asFormatter() {
        return this.asFormatter(InternalFormatter::doNothing);
    }

    @NonNull
    default public Formatter<T> asFormatter(@NonNull Consumer<? super Throwable> onError) {
        if (onError == null) {
            throw new NullPointerException("onError is marked non-null but is null");
        }
        return value -> {
            if (value != null) {
                try {
                    return this.formatToString(value);
                }
                catch (Throwable ex) {
                    onError.accept(ex);
                }
            }
            return null;
        };
    }

    @NonNull
    public static <T> TextFormatter<T> onFormattingWriter(@NonNull IOBiConsumer<? super T, ? super Writer> function) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        return new FunctionalTextFormatter<T>(function);
    }
}

