/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.internal.io.text;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import lombok.Generated;
import lombok.NonNull;
import standalone_spreadsheet.nbbrd.io.Resource;
import standalone_spreadsheet.nbbrd.io.function.IOBiConsumer;
import standalone_spreadsheet.nbbrd.io.text.TextFormatter;
import standalone_spreadsheet.nbbrd.io.text.TextResource;

public final class FunctionalTextFormatter<T>
implements TextFormatter<T> {
    @NonNull
    private final IOBiConsumer<? super T, ? super Writer> function;

    @Override
    public void formatWriter(@NonNull T value, @NonNull Writer resource) throws IOException {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (resource == null) {
            throw new NullPointerException("resource is marked non-null but is null");
        }
        this.doWrite(value, TextResource.uncloseableWriter(resource));
    }

    @Override
    public void formatStream(@NonNull T value, @NonNull OutputStream resource, @NonNull Charset encoding) throws IOException {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (resource == null) {
            throw new NullPointerException("resource is marked non-null but is null");
        }
        if (encoding == null) {
            throw new NullPointerException("encoding is marked non-null but is null");
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(Resource.uncloseableOutputStream(resource), encoding);){
            this.doWrite(value, writer);
        }
    }

    private void doWrite(T value, Writer resource) throws IOException {
        this.function.acceptWithIO(value, resource);
    }

    @Generated
    public FunctionalTextFormatter(@NonNull IOBiConsumer<? super T, ? super Writer> function) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        this.function = function;
    }
}

