/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.nbbrd.io.sys;

import java.io.BufferedReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import lombok.NonNull;
import standalone_spreadsheet.internal.io.text.InternalTextResource;
import standalone_spreadsheet.nbbrd.io.sys.EndOfProcessException;
import standalone_spreadsheet.nbbrd.io.text.TextResource;

public final class ProcessReader {
    private ProcessReader() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @Deprecated
    @NonNull
    public static BufferedReader newReader(String ... args) throws IOException {
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        return ProcessReader.newReader(ProcessReader.getSystemCharset(), args);
    }

    @Deprecated
    @NonNull
    public static BufferedReader newReader(@NonNull Process process) {
        if (process == null) {
            throw new NullPointerException("process is marked non-null but is null");
        }
        return ProcessReader.newReader(ProcessReader.getSystemCharset(), process);
    }

    @Deprecated
    @NonNull
    public static String readToString(String ... args) throws IOException {
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        return ProcessReader.readToString(ProcessReader.getSystemCharset(), args);
    }

    @Deprecated
    @NonNull
    public static String readToString(@NonNull Process process) throws IOException {
        if (process == null) {
            throw new NullPointerException("process is marked non-null but is null");
        }
        return ProcessReader.readToString(ProcessReader.getSystemCharset(), process);
    }

    @NonNull
    public static BufferedReader newReader(@NonNull Charset charset, String ... args) throws IOException {
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        return ProcessReader.newReader(charset, new ProcessBuilder(args).start());
    }

    @NonNull
    public static BufferedReader newReader(@NonNull Charset charset, @NonNull Process process) {
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        if (process == null) {
            throw new NullPointerException("process is marked non-null but is null");
        }
        return TextResource.newBufferedReader((InputStream)new ProcessInputStream(process), charset);
    }

    @NonNull
    public static String readToString(@NonNull Charset charset, String ... args) throws IOException {
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        return ProcessReader.readToString(charset, new ProcessBuilder(args).start());
    }

    @NonNull
    public static String readToString(@NonNull Charset charset, @NonNull Process process) throws IOException {
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        if (process == null) {
            throw new NullPointerException("process is marked non-null but is null");
        }
        try (BufferedReader reader = ProcessReader.newReader(charset, process);){
            String string = InternalTextResource.copyByLineToString(reader, System.lineSeparator());
            return string;
        }
    }

    private static Charset getSystemCharset() {
        return Charset.defaultCharset();
    }

    private static final class ProcessInputStream
    extends FilterInputStream {
        private final Process process;

        public ProcessInputStream(Process process) {
            super(process.getInputStream());
            this.process = process;
        }

        @Override
        public void close() throws IOException {
            try {
                this.readUntilEnd();
                this.waitForEndOfProcess();
            }
            finally {
                super.close();
            }
        }

        private void readUntilEnd() throws IOException {
            while (super.read() != -1) {
            }
        }

        private void waitForEndOfProcess() throws IOException {
            try {
                this.process.waitFor();
            }
            catch (InterruptedException ex) {
                throw new IOException(ex);
            }
            if (this.process.exitValue() != 0) {
                throw EndOfProcessException.of(this.process);
            }
        }
    }
}

