/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.api.tramoseats;

import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import jdplus.tramoseats.base.api.tramoseats.TramoSeats;

public final class TramoSeatsLoader {

    public static final class Processor {
        private final Iterable<TramoSeats.Processor> source = ServiceLoader.load(TramoSeats.Processor.class);
        private final AtomicReference<TramoSeats.Processor> resource = new AtomicReference<TramoSeats.Processor>(this.doLoad());
        private final Consumer<Iterable> cleaner = loader -> ((ServiceLoader)loader).reload();

        private TramoSeats.Processor doLoad() {
            return StreamSupport.stream(this.source.spliterator(), false).findFirst().orElseGet(() -> new TramoSeats.DefProcessor());
        }

        public TramoSeats.Processor get() {
            return this.resource.get();
        }

        public void set(TramoSeats.Processor newValue) {
            this.resource.set(Objects.requireNonNull(newValue));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reload() {
            Iterable<TramoSeats.Processor> iterable = this.source;
            synchronized (iterable) {
                this.cleaner.accept(this.source);
                this.set(this.doLoad());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            Iterable<TramoSeats.Processor> iterable = this.source;
            synchronized (iterable) {
                this.set(this.doLoad());
            }
        }
    }
}

