/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x11.extremevaluecorrector;

import java.util.Arrays;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.Doubles;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.x13.base.core.x11.extremevaluecorrector.DefaultExtremeValuesCorrector;

public class PeriodSpecificExtremeValuesCorrector
extends DefaultExtremeValuesCorrector {
    private static final double EPS = 1.0E-15;
    private static final double EPS_STDEV = 1.0E-5;

    @Override
    protected double[] calcStdev(DoubleSeq s) {
        int nstart = this.start;
        if (this.excludeFcast) {
            s = s.drop(this.backcastHorizon, this.forecastHorizon);
            nstart = (this.start + this.backcastHorizon) % this.period;
        }
        double[] stdev = new double[this.period];
        for (int i = 0; i < this.period; ++i) {
            int j = ((this.period - nstart) % this.period + i) % this.period;
            DoubleSeq sPeriod = s.extract(j, -1, this.period);
            stdev[i] = this.calcSingleStdev(sPeriod);
        }
        return stdev;
    }

    @Override
    protected DoubleSeq extremeValuesDetection(DoubleSeq cur, double[] stdev) {
        int n = cur.length();
        double[] w = new double[n];
        Arrays.fill(w, 1.0);
        double xbar = this.mul ? 1.0 : 0.0;
        for (int iPeriod = 0; iPeriod < this.period; ++iPeriod) {
            boolean isNullStdev = false;
            double lv = stdev[iPeriod] * this.lsigma;
            double uv = stdev[iPeriod] * this.usigma;
            if (Math.abs(stdev[iPeriod]) < 1.0E-5) {
                isNullStdev = true;
            }
            int j = ((this.period - this.start) % this.period + iPeriod) % this.period;
            DataBlock dCur = DataBlock.of((DoubleSeq)cur);
            DataBlock dsPeriod = dCur.extract(j, -1, this.period);
            if (isNullStdev) continue;
            for (int i = 0; i < dsPeriod.length(); ++i) {
                double tt = Math.abs(dsPeriod.get(i) - xbar);
                if (tt - uv > 1.0E-15) {
                    w[i * this.period + j] = 0.0;
                    continue;
                }
                if (!(tt - lv > 1.0E-15)) continue;
                w[i * this.period + j] = (uv - tt) / (uv - lv);
            }
        }
        return Doubles.of((double[])w);
    }
}

