/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x11.filter;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearfilters.FiniteFilter;
import jdplus.toolkit.base.core.math.linearfilters.IFiniteFilter;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;
import jdplus.x13.base.api.x11.SeasonalFilterOption;
import jdplus.x13.base.core.x11.filter.IFiltering;
import jdplus.x13.base.core.x11.filter.X11FilterFactory;
import jdplus.x13.base.core.x11.filter.X11SeasonalFilterProcessor;
import jdplus.x13.base.core.x11.filter.endpoints.AsymmetricEndPoints;
import jdplus.x13.base.core.x11.filter.endpoints.IEndPointsProcessor;
import lombok.Generated;

public final class X11SeasonalFiltersFactory {
    public static final SymmetricFilter S3X1 = X11FilterFactory.makeSymmetricFilter(3, 1);
    public static final SymmetricFilter S3X3 = X11FilterFactory.makeSymmetricFilter(3, 3);
    public static final SymmetricFilter S3X5 = X11FilterFactory.makeSymmetricFilter(3, 5);
    public static final SymmetricFilter S3X9 = X11FilterFactory.makeSymmetricFilter(3, 9);
    public static final SymmetricFilter S3X15 = X11FilterFactory.makeSymmetricFilter(3, 15);
    private static final double[] MA1X0 = new double[]{0.39, 0.61};
    private static final double[] MA2X1 = new double[]{0.1111111111111111, 0.25925925925925924, 0.37037037037037035, 0.25925925925925924};
    private static final double[] MA2X0 = new double[]{0.18518518518518517, 0.4074074074074074, 0.4074074074074074};
    private static final double[] MA3X2 = new double[]{0.06666666666666667, 0.13333333333333333, 0.21666666666666667, 0.21666666666666667, 0.21666666666666667, 0.15};
    private static final double[] MA3X1 = new double[]{0.06666666666666667, 0.18333333333333332, 0.25, 0.25, 0.25};
    private static final double[] MA3X0 = new double[]{0.15, 0.2833333333333333, 0.2833333333333333, 0.2833333333333333};
    private static final double[] MA5X4 = new double[]{0.034, 0.073, 0.111, 0.113, 0.114, 0.116, 0.117, 0.118, 0.12, 0.084};
    private static final double[] MA5X3 = new double[]{0.034, 0.075, 0.113, 0.117, 0.123, 0.128, 0.132, 0.137, 0.141};
    private static final double[] MA5X2 = new double[]{0.032, 0.079, 0.123, 0.133, 0.143, 0.154, 0.163, 0.173};
    private static final double[] MA5X1 = new double[]{0.028, 0.092, 0.144, 0.16, 0.176, 0.192, 0.208};
    private static final double[] MA5X0 = new double[]{0.051, 0.112, 0.173, 0.197, 0.221, 0.246};
    private static final double[] MA8X0 = new double[]{0.02222, 0.04444, 0.06667, 0.06667, 0.16, 0.16, 0.16, 0.16, 0.16};
    private static final double[] MA8X1 = new double[]{0.0222, 0.04444, 0.06667, 0.06667, 0.06667, 0.14667, 0.14667, 0.14667, 0.14667, 0.14667};
    private static final double[] MA8X2 = new double[]{0.02223, 0.04444, 0.06667, 0.06667, 0.06667, 0.06667, 0.13333, 0.13333, 0.13333, 0.13333, 0.13333};
    private static final double[] MA8X3 = new double[]{0.02221, 0.04444, 0.06667, 0.06667, 0.06667, 0.06667, 0.06667, 0.12, 0.12, 0.12, 0.12, 0.12};
    private static final double[] MA8X4 = new double[]{0.02219, 0.04444, 0.06667, 0.06667, 0.06667, 0.06667, 0.06667, 0.06667, 0.10667, 0.10667, 0.10667, 0.10667, 0.10667};
    private static final double[] MA8X5 = new double[]{0.02222, 0.04444, 0.06667, 0.06667, 0.06667, 0.06667, 0.06667, 0.06667, 0.06667, 0.09333, 0.09333, 0.09333, 0.09333, 0.09333};
    private static final double[] MA8X6 = new double[]{0.0222, 0.04444, 0.06667, 0.06667, 0.06667, 0.06667, 0.06667, 0.06667, 0.06667, 0.06667, 0.08, 0.08, 0.08, 0.08, 0.08};
    private static final double[] MA8X7 = new double[]{0.0222, 0.04444, 0.06667, 0.06667, 0.06667, 0.06667, 0.06667, 0.06667, 0.06667, 0.06667, 0.06667, 0.07111, 0.07111, 0.07111, 0.07111, 0.04889};
    static final FiniteFilter M_1X0 = FiniteFilter.ofInternal((double[])MA1X0, (int)-1);
    static final FiniteFilter M_2X1 = FiniteFilter.ofInternal((double[])MA2X1, (int)-2);
    static final FiniteFilter M_2X0 = FiniteFilter.ofInternal((double[])MA2X0, (int)-2);
    static final FiniteFilter M_3X2 = FiniteFilter.ofInternal((double[])MA3X2, (int)-3);
    static final FiniteFilter M_3X1 = FiniteFilter.ofInternal((double[])MA3X1, (int)-3);
    static final FiniteFilter M_3X0 = FiniteFilter.ofInternal((double[])MA3X0, (int)-3);
    static final FiniteFilter M_5X4 = FiniteFilter.ofInternal((double[])MA5X4, (int)-5);
    static final FiniteFilter M_5X3 = FiniteFilter.ofInternal((double[])MA5X3, (int)-5);
    static final FiniteFilter M_5X2 = FiniteFilter.ofInternal((double[])MA5X2, (int)-5);
    static final FiniteFilter M_5X1 = FiniteFilter.ofInternal((double[])MA5X1, (int)-5);
    static final FiniteFilter M_5X0 = FiniteFilter.ofInternal((double[])MA5X0, (int)-5);
    static final FiniteFilter M_8X0 = FiniteFilter.ofInternal((double[])MA8X0, (int)-8);
    static final FiniteFilter M_8X1 = FiniteFilter.ofInternal((double[])MA8X1, (int)-8);
    static final FiniteFilter M_8X2 = FiniteFilter.ofInternal((double[])MA8X2, (int)-8);
    static final FiniteFilter M_8X3 = FiniteFilter.ofInternal((double[])MA8X3, (int)-8);
    static final FiniteFilter M_8X4 = FiniteFilter.ofInternal((double[])MA8X4, (int)-8);
    static final FiniteFilter M_8X5 = FiniteFilter.ofInternal((double[])MA8X5, (int)-8);
    static final FiniteFilter M_8X6 = FiniteFilter.ofInternal((double[])MA8X6, (int)-8);
    static final FiniteFilter M_8X7 = FiniteFilter.ofInternal((double[])MA8X7, (int)-8);
    static final FiniteFilter[] FC1 = new FiniteFilter[]{M_1X0};
    static final FiniteFilter[] FC3 = new FiniteFilter[]{M_2X1, M_2X0};
    static final FiniteFilter[] FC5 = new FiniteFilter[]{M_3X2, M_3X1, M_3X0};
    static final FiniteFilter[] FC9 = new FiniteFilter[]{M_5X4, M_5X3, M_5X2, M_5X1, M_5X0};
    static final FiniteFilter[] FC15 = new FiniteFilter[]{M_8X7, M_8X6, M_8X5, M_8X4, M_8X3, M_8X2, M_8X1, M_8X0};

    public static X11SeasonalFilterProcessor filter(int period, SeasonalFilterOption[] option) {
        IFiltering[] result = new IFiltering[period];
        block8: for (int i = 0; i < period; ++i) {
            switch (option[i]) {
                case S3X1: {
                    result[i] = new DefaultFilter(period, S3X1, new AsymmetricEndPoints((IFiniteFilter[])FC1, 0));
                    continue block8;
                }
                case S3X3: {
                    result[i] = new DefaultFilter(period, S3X3, new AsymmetricEndPoints((IFiniteFilter[])FC3, 0));
                    continue block8;
                }
                case S3X5: {
                    result[i] = new DefaultFilter(period, S3X5, new AsymmetricEndPoints((IFiniteFilter[])FC5, 0));
                    continue block8;
                }
                case S3X9: {
                    result[i] = new DefaultFilter(period, S3X9, new AsymmetricEndPoints((IFiniteFilter[])FC9, 0));
                    continue block8;
                }
                case S3X15: {
                    result[i] = new DefaultFilter(period, S3X15, new AsymmetricEndPoints((IFiniteFilter[])FC15, 0));
                    continue block8;
                }
                case Stable: {
                    result[i] = new StableFilter(period);
                }
            }
        }
        return new X11SeasonalFilterProcessor(result);
    }

    @Generated
    private X11SeasonalFiltersFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static class DefaultFilter
    implements IFiltering {
        private final SymmetricFilter sfilter;
        private final IEndPointsProcessor endpoints;
        private final int period;

        public SymmetricFilter getSfilter() {
            return this.sfilter;
        }

        public IEndPointsProcessor getEndpoints() {
            return this.endpoints;
        }

        DefaultFilter(int period, SymmetricFilter sfilter, IEndPointsProcessor endpoints) {
            this.period = period;
            this.sfilter = sfilter;
            this.endpoints = endpoints;
        }

        @Override
        public DataBlock process(DataBlock cin) {
            DataBlock cout = DataBlock.of((double[])new double[cin.length()]);
            int n = this.sfilter.length() / 2;
            if (2 * n < cin.length()) {
                this.sfilter.apply(cin, cout.drop(n, n));
            }
            if (this.endpoints != null) {
                this.endpoints.process((DoubleSeq)cin, cout);
            }
            return cout;
        }
    }

    static class StableFilter
    implements IFiltering {
        private final int period;

        StableFilter(int period) {
            this.period = period;
        }

        @Override
        public DataBlock process(DataBlock cin) {
            DataBlock cout = DataBlock.of((double[])new double[cin.length()]);
            cout.set(cin.average());
            return cout;
        }
    }
}

