/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.trees.iadem;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import moa.classifiers.core.AttributeSplitSuggestion;
import moa.classifiers.core.attributeclassobservers.AttributeClassObserver;
import moa.classifiers.core.attributeclassobservers.VFMLNumericAttributeClassObserver;
import moa.classifiers.core.splitcriteria.SplitCriterion;
import moa.classifiers.trees.iadem.IademCommonProcedures;
import moa.classifiers.trees.iadem.IademNumericAttributeBinaryTest;
import moa.classifiers.trees.iadem.IademNumericAttributeObserver;
import moa.core.DoubleVector;
import moa.core.ObjectRepository;
import moa.tasks.TaskMonitor;
import weka.core.Utils;

public class IademVFMLNumericAttributeClassObserver
extends VFMLNumericAttributeClassObserver
implements IademNumericAttributeObserver,
AttributeClassObserver {
    private static final long serialVersionUID = 1L;
    protected List<Bin> binList = new ArrayList<Bin>();
    protected DoubleVector classDist = new DoubleVector();

    public IademVFMLNumericAttributeClassObserver() {
        this.numBinsOption.setValue(500);
    }

    public IademVFMLNumericAttributeClassObserver(int maxBins) {
        this.numBinsOption.setValue(maxBins);
    }

    @Override
    public void setMaxBins(int numBins) {
        this.numBinsOption.setValue(numBins);
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
    }

    @Override
    public void computeClassDist(double[][][] cutClassDist) {
        int i;
        int classes = this.classDist.numValues();
        Bin element = this.binList.get(0);
        double numLeftInst = element.classWeights.sumOfValues();
        double numRightInst = this.classDist.sumOfValues() - numLeftInst;
        double[] leftClassDist = new double[classes];
        double[] rightClassDist = new double[classes];
        for (i = 0; i < classes; ++i) {
            leftClassDist[i] = element.classWeights.getValue(i);
            rightClassDist[i] = this.classDist.getValue(i) - leftClassDist[i];
            cutClassDist[0][0][i] = leftClassDist[i];
            cutClassDist[0][1][i] = rightClassDist[i];
        }
        for (i = 1; i < this.binList.size() - 1; ++i) {
            element = this.binList.get(i);
            double numChangingInst = element.classWeights.sumOfValues();
            numLeftInst += numChangingInst;
            numRightInst -= numChangingInst;
            for (int j = 0; j < classes; ++j) {
                double changingClassDist = element.classWeights.getValue(j);
                int n = j;
                leftClassDist[n] = leftClassDist[n] + changingClassDist;
                int n2 = j;
                rightClassDist[n2] = rightClassDist[n2] - changingClassDist;
                cutClassDist[i][0][j] = leftClassDist[j];
                cutClassDist[i][1][j] = rightClassDist[j];
            }
        }
    }

    @Override
    public void observeAttributeClass(double attVal, int classVal, double weight) {
        if (!Utils.isMissingValue((double)attVal)) {
            if (this.binList.size() < 1) {
                Bin newBin = new Bin();
                newBin.classWeights.addToValue(classVal, weight);
                newBin.boundaryClass = classVal;
                newBin.boundaryWeight = weight;
                newBin.upperBound = attVal;
                newBin.lowerBound = attVal;
                this.binList.add(newBin);
            } else {
                Bin bin;
                int index = -1;
                boolean found = false;
                int min = 0;
                int max = this.binList.size() - 1;
                index = 0;
                while (min <= max && !found) {
                    int i = (min + max) / 2;
                    Bin bin2 = this.binList.get(i);
                    if (attVal >= bin2.lowerBound && attVal < bin2.upperBound || i == this.binList.size() - 1 && attVal >= bin2.lowerBound && attVal <= bin2.upperBound) {
                        found = true;
                        index = i;
                        continue;
                    }
                    if (attVal < bin2.lowerBound) {
                        max = i - 1;
                        continue;
                    }
                    min = i + 1;
                }
                boolean first = false;
                boolean last = false;
                if (!found) {
                    bin = this.binList.get(0);
                    if (bin.lowerBound > attVal) {
                        index = 0;
                        first = true;
                    } else {
                        index = this.binList.size() - 1;
                        last = true;
                    }
                }
                bin = this.binList.get(index);
                if (bin.lowerBound == attVal || this.binList.size() >= this.numBinsOption.getValue()) {
                    bin.classWeights.addToValue(classVal, weight);
                    if (bin.boundaryClass == classVal && bin.lowerBound == attVal) {
                        bin.boundaryWeight += weight;
                    }
                } else {
                    Bin newBin = new Bin();
                    newBin.classWeights.addToValue(classVal, weight);
                    newBin.boundaryWeight = weight;
                    newBin.boundaryClass = classVal;
                    newBin.upperBound = bin.upperBound;
                    newBin.lowerBound = attVal;
                    double percent = 0.0;
                    if (bin.upperBound - bin.lowerBound != 0.0 && !last && !first) {
                        percent = 1.0 - (attVal - bin.lowerBound) / (bin.upperBound - bin.lowerBound);
                    }
                    bin.classWeights.addToValue(bin.boundaryClass, -bin.boundaryWeight);
                    DoubleVector weightToShift = new DoubleVector(bin.classWeights);
                    weightToShift.scaleValues(percent);
                    for (int i = 0; i < weightToShift.numValues(); ++i) {
                        long tmp = Math.round(weightToShift.getValue(i));
                        weightToShift.setValue(i, tmp);
                    }
                    newBin.classWeights.addValues(weightToShift);
                    bin.classWeights.subtractValues(weightToShift);
                    bin.classWeights.addToValue(bin.boundaryClass, bin.boundaryWeight);
                    if (last) {
                        bin.upperBound = attVal;
                        newBin.upperBound = attVal;
                        this.binList.add(newBin);
                    } else if (first) {
                        newBin.upperBound = bin.lowerBound;
                        this.binList.add(0, newBin);
                    } else {
                        newBin.upperBound = bin.upperBound;
                        bin.upperBound = attVal;
                        this.binList.add(index + 1, newBin);
                    }
                }
            }
        }
    }

    @Override
    public AttributeSplitSuggestion getBestEvaluatedSplitSuggestion(SplitCriterion criterion, double[] preSplitDist, int attIndex, boolean binaryOnly) {
        AttributeSplitSuggestion bestSuggestion = null;
        DoubleVector rightDist = new DoubleVector();
        for (Bin bin : this.binList) {
            rightDist.addValues(bin.classWeights);
        }
        DoubleVector leftDist = new DoubleVector();
        for (Bin bin : this.binList) {
            leftDist.addValues(bin.classWeights);
            rightDist.subtractValues(bin.classWeights);
            double[][] postSplitDists = new double[][]{leftDist.getArrayCopy(), rightDist.getArrayCopy()};
            double merit = criterion.getMeritOfSplit(preSplitDist, postSplitDists);
            if (bestSuggestion != null && !(merit > bestSuggestion.merit)) continue;
            bestSuggestion = new AttributeSplitSuggestion(new IademNumericAttributeBinaryTest(attIndex, bin.upperBound, false), postSplitDists, merit);
        }
        return bestSuggestion;
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    @Override
    public double probabilityOfAttributeValueGivenClass(double attVal, int classVal) {
        double attValClassValCount = 0.0;
        double totalClassValCount = 0.0;
        for (int i = 0; i < this.binList.size(); ++i) {
            if (attVal == this.binList.get((int)i).lowerBound && classVal == this.binList.get((int)i).boundaryClass) {
                attValClassValCount = this.binList.get((int)i).boundaryWeight;
            } else if (attVal >= this.binList.get((int)i).lowerBound && attVal < this.binList.get((int)i).upperBound || i == this.binList.size() - 1 && attVal >= this.binList.get((int)i).lowerBound && attVal <= this.binList.get((int)i).upperBound) {
                attValClassValCount = this.binList.get((int)i).classWeights.getValue(classVal);
            }
            totalClassValCount += this.binList.get((int)i).classWeights.getValue(classVal);
        }
        return totalClassValCount != 0.0 ? attValClassValCount / totalClassValCount : 0.0;
    }

    public void forgetAttributeClass(double attVal, int classVal, double weight) {
        if (!Utils.isMissingValue((double)attVal) && this.classDist.sumOfValues() > 0.0) {
            Bin bin;
            this.classDist.addToValue(classVal, -weight);
            boolean found = false;
            int numBins = this.binList.size();
            int index = 0;
            int min = 0;
            int max = numBins - 1;
            while (min <= max && !found) {
                int i = (min + max) / 2;
                bin = this.binList.get(i);
                if (attVal >= bin.lowerBound && attVal < bin.upperBound || i == numBins - 1 && attVal >= bin.lowerBound && attVal <= bin.upperBound) {
                    found = true;
                    index = i;
                    continue;
                }
                if (attVal < bin.lowerBound) {
                    max = i - 1;
                    continue;
                }
                min = i + 1;
            }
            if (!found) {
                return;
            }
            bin = this.binList.get(index);
            bin.classWeights.addToValue(classVal, -weight);
            if (bin.classWeights.getValue(classVal) < 0.0) {
                bin.classWeights.setValue(classVal, 0.0);
            }
            if (bin.boundaryClass == classVal) {
                bin.boundaryWeight -= weight;
            }
            if (bin.boundaryWeight < 0.0) {
                bin.boundaryWeight = 0.0;
            }
            if (bin.boundaryWeight == 0.0 && this.binList.size() > 0) {
                int numClasses = bin.classWeights.numValues();
                if (index != 0) {
                    Bin prevBin = this.binList.get(index - 1);
                    prevBin.upperBound = bin.upperBound;
                    for (int j = 0; j < numClasses; ++j) {
                        prevBin.classWeights.addToValue(j, bin.classWeights.getValue(j));
                    }
                    this.binList.remove(index);
                    bin = this.binList.get(index - 1);
                } else if (this.binList.size() > 1) {
                    Bin newFirstBin = this.binList.get(1);
                    Bin oldFirstBin = this.binList.get(0);
                    newFirstBin.lowerBound = oldFirstBin.lowerBound;
                    for (int j = 0; j < numClasses; ++j) {
                        newFirstBin.classWeights.addToValue(j, oldFirstBin.classWeights.getValue(j));
                    }
                    this.binList.remove(0);
                }
            }
        }
    }

    @Override
    public void reset() {
        this.classDist = new DoubleVector();
        this.binList = new ArrayList<Bin>();
    }

    @Override
    public long getValueCount() {
        return (long)this.classDist.sumOfValues();
    }

    @Override
    public long[] getClassDist() {
        long[] classDistCopy = new long[this.classDist.numValues()];
        for (int i = 0; i < this.classDist.numValues(); ++i) {
            classDistCopy[i] = (long)this.classDist.getValue(i);
        }
        return classDistCopy;
    }

    @Override
    public long getNumberOfCutPoints() {
        return this.binList.size() - 1;
    }

    @Override
    public long[] getLeftClassDist(double corte) {
        long[] rightDist = new long[this.classDist.numValues()];
        Arrays.fill(rightDist, 0L);
        for (int i = 0; i < this.binList.size() && corte > this.binList.get((int)i).upperBound; ++i) {
            for (int j = 0; j < this.binList.get((int)i).classWeights.numValues(); ++j) {
                int n = j;
                rightDist[n] = (long)((double)rightDist[n] + this.binList.get((int)i).classWeights.getValue(j));
            }
        }
        return rightDist;
    }

    @Override
    public double getCut(int indice) {
        return this.binList.get((int)indice).upperBound;
    }

    @Override
    public void computeClassDistProbabilities(double[][][] cut_value_classDist_lower, double[][][] cut_value_classDist_upper, double[][] counts_cut_value, boolean withIntervalEstimates) {
        int i;
        int classes = this.classDist.numValues();
        Bin element = this.binList.get(0);
        double numLeftInst = element.classWeights.sumOfValues();
        double numRightInst = this.classDist.sumOfValues() - numLeftInst;
        counts_cut_value[0][0] = numLeftInst;
        counts_cut_value[0][1] = numRightInst;
        double[] leftClassDist = new double[classes];
        double[] rightClassDist = new double[classes];
        for (i = 0; i < classes; ++i) {
            leftClassDist[i] = element.classWeights.getValue(i);
            rightClassDist[i] = this.classDist.getValue(i) - leftClassDist[i];
            double lEstimates = 0.0;
            if (numLeftInst != 0.0) {
                lEstimates = leftClassDist[i] / numLeftInst;
            }
            double lError = 0.0;
            if (withIntervalEstimates) {
                lError = IademCommonProcedures.getIADEM_HoeffdingBound(lEstimates, numLeftInst);
            }
            cut_value_classDist_lower[0][0][i] = Math.max(0.0, lEstimates - lError);
            cut_value_classDist_upper[0][0][i] = Math.min(1.0, lEstimates + lError);
            double rEstimates = 0.0;
            if (numRightInst != 0.0) {
                rEstimates = rightClassDist[i] / numRightInst;
            }
            double rError = 0.0;
            if (withIntervalEstimates) {
                rError = IademCommonProcedures.getIADEM_HoeffdingBound(rEstimates, numRightInst);
            }
            cut_value_classDist_lower[0][1][i] = Math.max(0.0, rEstimates - rError);
            cut_value_classDist_upper[0][1][i] = Math.min(1.0, rEstimates + rError);
        }
        for (i = 1; i < this.binList.size() - 1; ++i) {
            element = this.binList.get(i);
            double numChangingInst = element.classWeights.sumOfValues();
            counts_cut_value[i][0] = numLeftInst += numChangingInst;
            counts_cut_value[i][1] = numRightInst -= numChangingInst;
            for (int j = 0; j < classes; ++j) {
                double changingClassDist = element.classWeights.getValue(j);
                int n = j;
                leftClassDist[n] = leftClassDist[n] + changingClassDist;
                int n2 = j;
                rightClassDist[n2] = rightClassDist[n2] - changingClassDist;
                double lEstimates = 0.0;
                if (numLeftInst != 0.0) {
                    lEstimates = leftClassDist[j] / numLeftInst;
                }
                double lError = 0.0;
                if (withIntervalEstimates) {
                    lError = IademCommonProcedures.getIADEM_HoeffdingBound(lEstimates, numLeftInst);
                }
                cut_value_classDist_lower[i][0][j] = Math.max(0.0, lEstimates - lError);
                cut_value_classDist_upper[i][0][j] = Math.min(1.0, lEstimates + lError);
                double rEstimates = 0.0;
                if (numRightInst != 0.0) {
                    rEstimates = rightClassDist[j] / numRightInst;
                }
                double rError = 0.0;
                if (withIntervalEstimates) {
                    rError = IademCommonProcedures.getIADEM_HoeffdingBound(rEstimates, numRightInst);
                }
                cut_value_classDist_lower[i][1][j] = Math.max(0.0, rEstimates - rError);
                cut_value_classDist_upper[i][1][j] = Math.min(1.0, rEstimates + rError);
            }
        }
    }

    @Override
    public ArrayList<Double> cutPointSuggestion(int numMaxIntervalos) {
        ArrayList<Double> cutPoint = new ArrayList<Double>();
        for (int i = 0; i < this.binList.size() - 1; ++i) {
            cutPoint.add(this.binList.get((int)i).upperBound);
        }
        return cutPoint;
    }

    @Override
    public ArrayList<Double[]> computeConditionalProbPerBin(ArrayList<Double> cortes) {
        ArrayList<Double[]> condProb = new ArrayList<Double[]>();
        int numClasses = this.classDist.numValues();
        double[] numClassesPerBin = new double[numClasses];
        Arrays.fill(numClassesPerBin, 0.0);
        int currentBin = 0;
        for (int j = 0; j < this.binList.size(); ++j) {
            int i;
            Bin element = this.binList.get(j);
            double aux = element.upperBound;
            if (currentBin == cortes.size() || aux <= cortes.get(currentBin)) {
                for (int i2 = 0; i2 < numClasses; ++i2) {
                    int n = i2;
                    numClassesPerBin[n] = numClassesPerBin[n] + element.classWeights.getValue(i2);
                }
                continue;
            }
            Double[] probCond_intervalo = new Double[numClasses];
            for (i = 0; i < numClasses; ++i) {
                probCond_intervalo[i] = this.classDist.getValue(i) == 0.0 ? Double.valueOf(0.0) : Double.valueOf(numClassesPerBin[i] / this.classDist.getValue(i));
            }
            condProb.add(probCond_intervalo);
            ++currentBin;
            while (currentBin < cortes.size() && aux > cortes.get(currentBin)) {
                ++currentBin;
                condProb.add(null);
            }
            Arrays.fill(numClassesPerBin, 0.0);
            for (i = 0; i < numClasses; ++i) {
                int n = i;
                numClassesPerBin[n] = numClassesPerBin[n] + element.classWeights.getValue(i);
            }
        }
        Double[] probCond_intervalo = new Double[numClasses];
        for (int i = 0; i < numClasses; ++i) {
            probCond_intervalo[i] = this.classDist.getValue(i) == 0.0 ? Double.valueOf(0.0) : Double.valueOf(numClassesPerBin[i] / this.classDist.getValue(i));
        }
        condProb.add(probCond_intervalo);
        return condProb;
    }

    @Override
    public double[] computeConditionalProb(ArrayList<Double> cuts, double cutValue) {
        int i;
        int keyPos;
        int numClasses = this.classDist.numValues();
        double[] instPerClass = new double[numClasses];
        Arrays.fill(instPerClass, 0.0);
        if (cutValue <= cuts.get(0)) {
            for (keyPos = 0; keyPos < this.binList.size() && this.binList.get((int)keyPos).upperBound <= cuts.get(0); ++keyPos) {
                for (i = 0; i < numClasses; ++i) {
                    int n = i;
                    instPerClass[n] = instPerClass[n] + this.binList.get((int)keyPos).classWeights.getValue(i);
                }
            }
        } else if (cutValue > cuts.get(cuts.size() - 1)) {
            for (keyPos = this.binList.size() - 1; keyPos < this.binList.size() && this.binList.get((int)keyPos).upperBound > cuts.get(cuts.size() - 1); --keyPos) {
                for (i = 0; i < numClasses; ++i) {
                    int n = i;
                    instPerClass[n] = instPerClass[n] + this.binList.get((int)keyPos).classWeights.getValue(i);
                }
            }
        } else {
            int currentBin = 1;
            double lastBin = cuts.get(currentBin);
            while (cutValue > lastBin) {
                lastBin = cuts.get(++currentBin);
            }
            double firstBin = cuts.get(currentBin - 1);
            for (keyPos = 0; keyPos < this.binList.size() && this.binList.get((int)keyPos).upperBound <= firstBin; ++keyPos) {
            }
            while (keyPos < this.binList.size() && this.binList.get((int)keyPos).upperBound <= lastBin) {
                for (int i2 = 0; i2 < numClasses; ++i2) {
                    int n = i2;
                    instPerClass[n] = instPerClass[n] + this.binList.get((int)keyPos).classWeights.getValue(i2);
                }
                ++keyPos;
            }
        }
        boolean allZero = true;
        for (int pos = 0; allZero && pos < numClasses; ++pos) {
            if (!(instPerClass[pos] > 0.0)) continue;
            allZero = false;
        }
        double[] classVotes = new double[numClasses];
        if (allZero) {
            for (int i3 = 0; i3 < numClasses; ++i3) {
                classVotes[i3] = 1.0 / (double)numClasses;
            }
        } else {
            for (int i4 = 0; i4 < numClasses; ++i4) {
                classVotes[i4] = this.classDist.getValue(i4) == 0.0 ? 0.0 : instPerClass[i4] / this.classDist.getValue(i4);
            }
        }
        return classVotes;
    }

    @Override
    public void addValue(double attValue, int classValue, double weight) {
        if (!Utils.isMissingValue((double)attValue)) {
            this.classDist.addToValue(classValue, weight);
            this.observeAttributeClass(attValue, classValue, weight);
        }
    }

    @Override
    public long getMaxOfValues() {
        return this.numBinsOption.getValue();
    }

    @Override
    public IademNumericAttributeObserver getCopy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected class Bin
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public double lowerBound;
        public double upperBound;
        public DoubleVector classWeights = new DoubleVector();
        public int boundaryClass;
        public double boundaryWeight;

        protected Bin() {
        }
    }
}

