# DarwinReporter <img src='vignettes/img/DarwinReporter.png' align="right" alt="DarwinReporter package logo." style = "float:right; height: 150px;" />

## Overview

The `Certara.DarwinReporter` package provides a Shiny application, in addition to various plotting and data summary functions for analyzing results of a [pyDarwin](https://certara.github.io/pyDarwin/html/index.html) automated model search. 

## Installation

```r
install.packages("Certara.DarwinReporter", 
  repos = c("https://certara.jfrog.io/artifactory/certara-cran-release-public/", 
  "https://cloud.r-project.org"), method = "libcurl")

```

## Usage

```r
library(Certara.DarwinReporter)

ddb <- darwin_data(project_dir = "./darwin_search_01") |>
  import_key_models("./darwin_search_01/key_models")
  
darwinReportUI(ddb)
```

<img src="vignettes/img/DarwinReporter.gif" alt="A gif demonstrating plot customization options in the VPCResults Shiny GUI." />

## System Requirements

In order to render reports to `pdf`, the `rmarkdown` package requires a `LaTeX` distribution available on the system. You can easily install this in R using the command below:

```r
install.packages('tinytex')
tinytex::install_tinytex()
```

