/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.common.util.preprocessor.graph;

import choco.kernel.model.constraints.Constraint;
import gnu.trove.THashMap;
import java.util.BitSet;

public final class ArrayGraph {
    private final BitSet[] mat;
    private int[][] adjmat;
    public int nbNode;
    public int nbEdges = 0;
    public THashMap<Edge, Constraint> storeEdges;

    public ArrayGraph(int n) {
        this.mat = new BitSet[n];
        this.adjmat = new int[n][];
        for (int i = 0; i < n; ++i) {
            this.mat[i] = new BitSet(n);
        }
        this.nbNode = n;
        this.storeEdges = new THashMap();
    }

    public void addEdge(int i, int j) {
        if (!this.mat[i].get(j)) {
            ++this.nbEdges;
        }
        if (!this.mat[j].get(i)) {
            ++this.nbEdges;
        }
        this.mat[i].set(j);
        this.mat[j].set(i);
    }

    public void setNeighbours() {
        for (int i = 0; i < this.mat.length; ++i) {
            this.adjmat[i] = new int[this.mat[i].cardinality()];
            int index = 0;
            int j = this.mat[i].nextSetBit(0);
            while (j >= 0) {
                this.adjmat[i][index] = j;
                ++index;
                j = this.mat[i].nextSetBit(j + 1);
            }
        }
    }

    public void remEdge(int i, int j) {
        if (this.mat[i].get(j)) {
            --this.nbEdges;
        }
        if (this.mat[j].get(i)) {
            --this.nbEdges;
        }
        this.mat[i].clear(j);
        this.mat[j].clear(i);
    }

    public boolean isIn(int i, int j) {
        return this.mat[i].get(j);
    }

    public int degree(int i) {
        return this.adjmat[i].length;
    }

    public int[] neighbours(int i) {
        return this.adjmat[i];
    }

    public int[] degrees() {
        int[] res = new int[this.mat.length];
        for (int i = 0; i < this.mat.length; ++i) {
            res[i] = this.degree(i);
        }
        return res;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (BitSet aMat : this.mat) {
            for (int j = 0; j < this.mat.length; ++j) {
                if (aMat.get(j)) {
                    s.append("x ");
                    continue;
                }
                s.append(". ");
            }
            s.append('\n');
        }
        return s.toString();
    }

    public void storeEdge(Constraint c, int a, int b) {
        this.storeEdges.put(new Edge(a, b), c);
    }

    public Constraint getConstraintEdge(int a, int b) {
        Constraint c = this.storeEdges.get(new Edge(a, b));
        Constraint c2 = this.storeEdges.get(new Edge(b, a));
        if (c != null) {
            return c;
        }
        if (c2 != null) {
            return c2;
        }
        return null;
    }

    public static class Edge {
        int a;
        int b;

        public Edge(int a, int b) {
            this.a = a;
            this.b = b;
        }

        public int hashCode() {
            return this.a * 10000000 + this.b;
        }

        public boolean equals(Object obj) {
            return Edge.class.isInstance(obj) && ((Edge)obj).a == this.a && ((Edge)obj).b == this.b;
        }
    }
}

