/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.bool;

import choco.cp.solver.constraints.integer.bool.BooleanFactory;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.propagation.event.ConstraintEvent;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class LargeXor
extends AbstractLargeIntSConstraint {
    LargeXor(IntDomainVar[] vars) {
        super(ConstraintEvent.LINEAR, vars);
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 8;
    }

    @Override
    public void awake() throws ContradictionException {
        for (int i = 0; i < ((IntDomainVar[])this.vars).length; ++i) {
            if (!((IntDomainVar[])this.vars)[i].isInstantiated()) continue;
            this.filter(i);
            break;
        }
    }

    private void filter(int idx) throws ContradictionException {
        int val = Math.abs(((IntDomainVar[])this.vars)[idx].getVal() - 1);
        for (int i = 0; i < ((IntDomainVar[])this.vars).length; ++i) {
            if (idx == i) continue;
            ((IntDomainVar[])this.vars)[i].instantiate(val, this, false);
        }
    }

    @Override
    public void propagate() throws ContradictionException {
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        this.filter(idx);
    }

    @Override
    public void awakeOnInf(int varIdx) throws ContradictionException {
    }

    @Override
    public void awakeOnSup(int varIdx) throws ContradictionException {
    }

    @Override
    public void awakeOnBounds(int varIndex) throws ContradictionException {
    }

    @Override
    public void awakeOnRemovals(int idx, DisposableIntIterator deltaDomain) throws ContradictionException {
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        int cnt = 0;
        for (int i = 0; i < tuple.length && cnt <= 1; ++i) {
            if (tuple[i] != 1) continue;
            ++cnt;
        }
        return cnt == 1;
    }

    @Override
    public Boolean isEntailed() {
        int cnt = 0;
        for (int i = 0; i < ((IntDomainVar[])this.vars).length && cnt <= 1; ++i) {
            if (((IntDomainVar[])this.vars)[i].isInstantiated()) {
                if (((IntDomainVar[])this.vars)[i].getVal() != 1) continue;
                ++cnt;
                continue;
            }
            return null;
        }
        return cnt == 1;
    }

    @Override
    public AbstractSConstraint<IntDomainVar> opposite(Solver solver) {
        return BooleanFactory.xnor((IntDomainVar[])this.vars);
    }
}

