/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.set;

import choco.cp.solver.constraints.set.IsIncluded;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.set.AbstractBinSetSConstraint;
import choco.kernel.solver.variables.set.SetVar;

public final class IsNotIncluded
extends AbstractBinSetSConstraint {
    public boolean prune;

    public IsNotIncluded(SetVar sv1, SetVar sv2) {
        super(sv1, sv2);
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 7;
    }

    public static boolean isKer1IncludedInKer2(SetVar x0, SetVar x1) {
        if (x0.getKernelDomainSize() <= x1.getKernelDomainSize()) {
            DisposableIntIterator it1 = x0.getDomain().getKernelIterator();
            while (it1.hasNext()) {
                if (x1.isInDomainKernel(it1.next())) continue;
                it1.dispose();
                return false;
            }
            it1.dispose();
            return true;
        }
        return false;
    }

    public static boolean isKer1IncludedInEnv2(SetVar x0, SetVar x1) {
        if (x0.getKernelDomainSize() <= x1.getEnveloppeDomainSize()) {
            DisposableIntIterator it1 = x0.getDomain().getKernelIterator();
            while (it1.hasNext()) {
                if (x1.isInDomainEnveloppe(it1.next())) continue;
                it1.dispose();
                return false;
            }
            it1.dispose();
            return true;
        }
        return false;
    }

    public int findUniqueOutsider() throws ContradictionException {
        this.prune = false;
        DisposableIntIterator it1 = this.v0.getDomain().getEnveloppeIterator();
        int uniqueOutsider = Integer.MAX_VALUE;
        while (it1.hasNext()) {
            int val = it1.next();
            if (this.v1.isInDomainKernel(val)) continue;
            if (!this.prune) {
                uniqueOutsider = val;
                this.prune = true;
                continue;
            }
            this.prune = false;
            it1.dispose();
            return Integer.MAX_VALUE;
        }
        it1.dispose();
        if (!this.prune) {
            this.fail();
        }
        return uniqueOutsider;
    }

    public void filter() throws ContradictionException {
        int uniqueOutsider = this.findUniqueOutsider();
        if (this.prune) {
            if (this.v0.isInDomainKernel(uniqueOutsider)) {
                this.v1.remFromEnveloppe(uniqueOutsider, this, true);
            }
            if (!this.v1.isInDomainEnveloppe(uniqueOutsider)) {
                this.v0.addToKernel(uniqueOutsider, this, true);
            }
        }
    }

    @Override
    public void awakeOnEnv(int varIdx, int x) throws ContradictionException {
        if (varIdx == 1 && this.v0.isInDomainKernel(x)) {
            this.setPassive();
        }
        this.filter();
    }

    @Override
    public void awakeOnKer(int varIdx, int x) throws ContradictionException {
        if (varIdx == 0 && !this.v1.isInDomainEnveloppe(x)) {
            this.setPassive();
        }
        this.filter();
    }

    @Override
    public void awakeOnInst(int varIdx) throws ContradictionException {
        this.filter();
    }

    @Override
    public void propagate() throws ContradictionException {
        this.filter();
    }

    @Override
    public boolean isSatisfied() {
        DisposableIntIterator it2 = this.v0.getDomain().getKernelIterator();
        while (it2.hasNext()) {
            if (this.v1.isInDomainKernel(it2.next())) continue;
            it2.dispose();
            return true;
        }
        it2.dispose();
        return false;
    }

    @Override
    public boolean isConsistent() {
        return this.isSatisfied();
    }

    @Override
    public String toString() {
        return this.v0 + " is Not Included in " + this.v1;
    }

    @Override
    public String pretty() {
        return this.v0.pretty() + " is Not Included in " + this.v1.pretty();
    }

    @Override
    public AbstractSConstraint<SetVar> opposite(Solver solver) {
        return new IsIncluded(this.v0, this.v1);
    }
}

