<!DOCTYPE style-sheet PUBLIC "-//James Clark//DTD DSSSL Style Sheet//EN" [
<!ENTITY % html "IGNORE">
<![%html;[
<!ENTITY % print "IGNORE">
<!ENTITY docbook.dsl PUBLIC "-//Norman Walsh//DOCUMENT DocBook HTML Stylesheet//EN" CDATA dsssl>
]]>
<!ENTITY % print "INCLUDE">
<![%print;[
<!ENTITY docbook.dsl PUBLIC "-//Norman Walsh//DOCUMENT DocBook Print Stylesheet//EN" CDATA dsssl>
]]>
]>

<!-- $Id: tex-refs.dsl,v 1.2 2002/06/14 16:49:12 mw Exp $ -->

<style-sheet>

<style-specification id="print" use="docbook">
<style-specification-body> 

;; ====================
;; customize the print stylesheet
;; ====================

;; The following lines are taken from the Mandrake customization
;; which were announced by Camille on Docbook-Apps ML on 2001-11-12.
;; For an english translation of the suggested customizations see the
;; document: "Correcting page make-up problems in SGML-based documentation"
;; at http://ricardo.ecn.wfu.edu/~cotreel/mandrake-sgml/pascal.pdf

;(define %bf-size% 11pt)

;; orig was 0.9
(define %verbatim-size-factor% 1)

;;
;(define %left-margin% 20mm)
;(define %right-margin% 20mm)
;(define %top-margin% 10mm)
;(define %bottom-margin% 15mm)
;(define %header-margin% 10mm)
;(define %footer-margin% 10mm)

;; orig was 4pi
(define %body-start-indent% 0pi)
(define %visual-acuity% "normal")
;; orig was 1.2
(define %hsize-bump-factor% 1.1)
;; orig was 1.3
(define %line-spacing-factor% 1.2)

;; orig was "Courier New"
;;(define %mono-font-family% "Computer-Modern-Typewriter")
(define %mono-font-family% "Courier New")

;; orig was "Arial"
(define %title-font-family% "Utopia")

;; Include the flow object class "formatting-instruction" : ONLY for Jade
(declare-flow-object-class formatting-instruction
       "UNREGISTERED::James Clark//Flow Object Class::formatting-instruction")

;; *** URLs ***
;; Use of the "url" package for LaTeX
;; Original : dblink.dsl
(element ulink
  (sosofo-append
   (process-children)                ;; Wrote the text with its format (anchor in HTML)
   (make formatting-instruction      ;; Wrote : " (\url{" + theUrl + "})"
     data: (string-append " (\\url{" (attribute-string (normalize "url")) "})")
   )
  )
)


;; *** Filenames ***
;; Use of the "url" package for LaTeX : 'path' command
;; Original : dbinline.dsl
(element filename
  (make formatting-instruction      ;; Wrote : " \path{" + theFilename + "}"
    data: (string-append "\\mypath{" (data-of (current-node)) "}")
  )
)
;; Must use "(data-of (current-node))" instead of "(process-children)"

;; These three elements are from "dbindex.dsl"
;; Must be placed here because of the redifinition of "ulink"
(element (primaryie ulink)
  (indexentry-link (current-node)))

(element (secondaryie ulink)
  (indexentry-link (current-node)))

(element (tertiaryie ulink)
  (indexentry-link (current-node)))


;; end of Mandrake customization

;(define %generate-article-toc% 
;  ;; Should a Table of Contents be produced for Articles?
;  ;; If true, a Table of Contents will be generated for each 'Article'.
;  #t)

;; this is necessary because right now jadetex does not understand
;; symbolic entities, whereas things work well with numeric entities.
(declare-characteristic preserve-sdata?
          "UNREGISTERED::James Clark//Characteristic::preserve-sdata?"
          #f)

(define %two-side% #t)

(define %section-autolabel% 
  ;; Are sections enumerated?
  #t)

(define %show-ulinks%
  #f)

(define %paper-type% "A4") 

;; uncomment if you want justified output instead
;; of the default left justified = 'start)
;; (possible values = 'start, 'center, 'justify)
(define %default-quadding% 'justify)

;; titlepage for books: "date" added
(define (book-titlepage-verso-elements)
  (list (normalize "title") 
        (normalize "subtitle") 
        (normalize "corpauthor") 
        (normalize "authorgroup") 
        (normalize "author") 
        (normalize "date") 
        (normalize "editor")
        (normalize "edition") 
        (normalize "pubdate") 
        (normalize "copyright")
        (normalize "abstract") 
        (normalize "legalnotice") 
        (normalize "revhistory")))


</style-specification-body>
</style-specification>

<!--
;; ====================
;; customize the html stylesheet
;; ====================
-->
<style-specification id="html" use="docbook">
<style-specification-body> 

;; this is necessary because right now jadetex does not understand
;; symbolic entities, whereas things work well with numeric entities.
(declare-characteristic preserve-sdata?
          "UNREGISTERED::James Clark//Characteristic::preserve-sdata?"
          #f)

;; Name for the root HTML document
(define %root-filename% "index")

;; put the legal notice in a separate file
(define %generate-legalnotice-link%
  #f)

;; use graphics in admonitions, and have their path be "stylesheet-images"
;; NO: they do not yet look very good
(define %admon-graphics-path%
  "./stylesheet-images/")
(define %admon-graphics%
  #f)

;; make funcsynopsis look pretty
(define %funcsynopsis-decoration%
  ;; Decorate elements of a FuncSynopsis?
  #t)


(define %html-ext% ".html")

(define %body-attr%
  ;; What attributes should be hung off of BODY?
;;  '())
  (list
   (list "BGCOLOR" "#CCCCCC")
;;   (list "TEXT" "#000000")))
;;   (list "BGCOLOR" "#a1a19e")
   (list "TEXT" "#000000")))

(define %shade-verbatim%
  #t)

(define %use-id-as-filename%
  ;; Use ID attributes as name for component HTML files?
  #t)

(define %graphic-default-extension% "jpg")

;; titlepage for BOOKS: "date" added
(define (book-titlepage-recto-elements)
  (list (normalize "title")
        (normalize "subtitle")
        (normalize "graphic")
        (normalize "mediaobject")
        (normalize "corpauthor")
        (normalize "authorgroup")
        (normalize "author")
        (normalize "date")
        (normalize "editor")
        (normalize "copyright")
        (normalize "abstract")
        (normalize "legalnotice")))

;;;; uncomment and use the role attribute with a value of 'bold' for the
;;;; emphasis tag if you want to render it as B in HTML output.
;;(element emphasis
;;    (if (equal? (normalize "bold") (attribute-string (normalize "role")))
;;        ($bold-seq$)                                                     
;;        ($italic-seq$)))

</style-specification-body>
</style-specification>

<external-specification id="docbook" document="docbook.dsl">

</style-sheet>












