/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries;

import java.time.Duration;
import java.time.Period;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdplus.toolkit.base.api.time.ISO_8601;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

@ISO_8601
public final class TsUnit
implements TemporalAmount {
    private final long amount;
    @NonNull
    private final ChronoUnit chronoUnit;
    public static final int NO_ANNUAL_FREQUENCY = -1;
    public static final int NO_RATIO = -1;
    public static final int NO_STRICT_RATIO = 0;
    public static final TsUnit UNDEFINED = new TsUnit(1L, ChronoUnit.FOREVER);
    public static final TsUnit P1Y = new TsUnit(1L, ChronoUnit.YEARS);
    public static final TsUnit P6M = new TsUnit(6L, ChronoUnit.MONTHS);
    public static final TsUnit P4M = new TsUnit(4L, ChronoUnit.MONTHS);
    public static final TsUnit P3M = new TsUnit(3L, ChronoUnit.MONTHS);
    public static final TsUnit P2M = new TsUnit(2L, ChronoUnit.MONTHS);
    public static final TsUnit P1M = new TsUnit(1L, ChronoUnit.MONTHS);
    public static final TsUnit P1W = new TsUnit(1L, ChronoUnit.WEEKS);
    public static final TsUnit P7D = new TsUnit(7L, ChronoUnit.DAYS);
    public static final TsUnit P1D = new TsUnit(1L, ChronoUnit.DAYS);
    public static final TsUnit PT1H = new TsUnit(1L, ChronoUnit.HOURS);
    public static final TsUnit PT1M = new TsUnit(1L, ChronoUnit.MINUTES);
    public static final TsUnit PT1S = new TsUnit(1L, ChronoUnit.SECONDS);
    private static final TsUnit P100Y = new TsUnit(100L, ChronoUnit.YEARS);
    private static final TsUnit P10Y = new TsUnit(10L, ChronoUnit.YEARS);
    @Deprecated
    public static final TsUnit CENTURY = P100Y;
    @Deprecated
    public static final TsUnit DECADE = P10Y;
    @Deprecated
    public static final TsUnit YEAR = P1Y;
    @Deprecated
    public static final TsUnit HALF_YEAR = P6M;
    @Deprecated
    public static final TsUnit QUARTER = P3M;
    @Deprecated
    public static final TsUnit MONTH = P1M;
    @Deprecated
    public static final TsUnit WEEK = P7D;
    @Deprecated
    public static final TsUnit DAY = P1D;
    @Deprecated
    public static final TsUnit HOUR = PT1H;
    @Deprecated
    public static final TsUnit MINUTE = PT1M;
    @Deprecated
    public static final TsUnit SECOND = PT1S;
    private static final Pattern DATE_PATTERN = Pattern.compile("P([0-9]+)([YMD])", 2);
    private static final Pattern TIME_PATTERN = Pattern.compile("PT([0-9]+)([HMS])", 2);
    private static final long[][] CHRONO_UNIT_RATIOS_ON_SECONDS = TsUnit.computeChronoUnitRatiosOnSeconds();

    public boolean contains(TsUnit other) {
        return other.ratioOf(this) > 0;
    }

    public int ratioOf(@NonNull TsUnit other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        double x = 1.0 * (double)other.chronoUnit.getDuration().getSeconds() / (double)this.chronoUnit.getDuration().getSeconds() * (double)other.amount / (double)this.amount;
        if (x < 1.0) {
            return -1;
        }
        if ((double)((int)x) != x) {
            return 0;
        }
        return (int)x;
    }

    public int getAnnualFrequency() {
        switch (this.chronoUnit) {
            case YEARS: {
                if (this.amount != 1L) break;
                return 1;
            }
            case MONTHS: {
                int n = (int)this.amount;
                if (12 % n != 0) break;
                return 12 / n;
            }
        }
        return -1;
    }

    public String toString() {
        return this.toISO8601();
    }

    private String toISO8601() {
        return switch (this.chronoUnit) {
            case ChronoUnit.FOREVER -> "";
            case ChronoUnit.HOURS, ChronoUnit.MINUTES, ChronoUnit.SECONDS -> Duration.of(this.amount, this.chronoUnit).toString();
            case ChronoUnit.WEEKS -> "P" + this.amount + "W";
            default -> Period.from(this).toString();
        };
    }

    public @Nullable ChronoUnit getPrecision() {
        return this.amount != 0L ? this.chronoUnit : null;
    }

    @Override
    public long get(TemporalUnit unit) {
        if (!this.chronoUnit.equals(unit)) {
            throw new UnsupportedTemporalTypeException(unit.toString());
        }
        return this.amount;
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return Collections.singletonList(this.chronoUnit);
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        return temporal.plus(this.amount, this.chronoUnit);
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        return temporal.minus(this.amount, this.chronoUnit);
    }

    @NonNull
    public static TsUnit of(long amount, @NonNull ChronoUnit unit) throws UnsupportedTemporalTypeException {
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        if (amount < 0L) {
            throw new IllegalArgumentException("Amount must be non-negative");
        }
        return switch (unit) {
            default -> throw new IncompatibleClassChangeError();
            case ChronoUnit.FOREVER -> UNDEFINED;
            case ChronoUnit.ERAS -> throw new UnsupportedTemporalTypeException(unit.toString());
            case ChronoUnit.MILLENNIA -> new TsUnit(1000L * amount, ChronoUnit.YEARS);
            case ChronoUnit.CENTURIES -> {
                if (amount == 1L) {
                    yield P100Y;
                }
                yield new TsUnit(100L * amount, ChronoUnit.YEARS);
            }
            case ChronoUnit.DECADES -> {
                if (amount == 1L) {
                    yield P10Y;
                }
                yield new TsUnit(10L * amount, ChronoUnit.YEARS);
            }
            case ChronoUnit.YEARS -> {
                if (amount == 1L) {
                    yield P1Y;
                }
                if (amount == 10L) {
                    yield P10Y;
                }
                if (amount == 100L) {
                    yield P100Y;
                }
                yield new TsUnit(amount, ChronoUnit.YEARS);
            }
            case ChronoUnit.MONTHS -> {
                if (amount == 1L) {
                    yield P1M;
                }
                if (amount == 2L) {
                    yield P2M;
                }
                if (amount == 3L) {
                    yield P3M;
                }
                if (amount == 4L) {
                    yield P4M;
                }
                if (amount == 6L) {
                    yield P6M;
                }
                yield new TsUnit(amount, ChronoUnit.MONTHS);
            }
            case ChronoUnit.WEEKS -> {
                if (amount == 1L) {
                    yield P1W;
                }
                yield new TsUnit(amount, ChronoUnit.WEEKS);
            }
            case ChronoUnit.DAYS -> {
                if (amount == 1L) {
                    yield P1D;
                }
                if (amount == 7L) {
                    yield P7D;
                }
                yield new TsUnit(amount, ChronoUnit.DAYS);
            }
            case ChronoUnit.HALF_DAYS -> new TsUnit(amount, ChronoUnit.HALF_DAYS);
            case ChronoUnit.HOURS -> {
                if (amount == 1L) {
                    yield PT1H;
                }
                yield new TsUnit(amount, ChronoUnit.HOURS);
            }
            case ChronoUnit.MINUTES -> {
                if (amount == 1L) {
                    yield PT1M;
                }
                yield new TsUnit(amount, ChronoUnit.MINUTES);
            }
            case ChronoUnit.SECONDS -> {
                if (amount == 1L) {
                    yield PT1S;
                }
                yield new TsUnit(amount, ChronoUnit.SECONDS);
            }
            case ChronoUnit.MILLIS -> throw new UnsupportedTemporalTypeException(unit.toString());
            case ChronoUnit.MICROS -> throw new UnsupportedTemporalTypeException(unit.toString());
            case ChronoUnit.NANOS -> throw new UnsupportedTemporalTypeException(unit.toString());
        };
    }

    @NonNull
    public static TsUnit ofAnnualFrequency(int freq) {
        return switch (freq) {
            case 1 -> P1Y;
            case 2 -> P6M;
            case 3 -> P4M;
            case 4 -> P3M;
            case 6 -> P2M;
            case 12 -> P1M;
            default -> throw new IllegalArgumentException("Illegal annual frequency: " + freq);
        };
    }

    @NonNull
    public static TsUnit parse(@NonNull CharSequence text) throws DateTimeParseException {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (text.isEmpty()) {
            return UNDEFINED;
        }
        if (text.length() == 1) {
            throw new DateTimeParseException("Text cannot be parsed to a freq", text, 0);
        }
        if (text.charAt(0) != 'P') {
            throw new DateTimeParseException("Text cannot be parsed to a freq", text, 0);
        }
        return text.charAt(1) == 'T' ? TsUnit.parseTimePattern(text) : TsUnit.parseDatePattern(text);
    }

    @NonNull
    public static TsUnit gcd(@NonNull TsUnit a, @NonNull TsUnit b) {
        if (a == null) {
            throw new NullPointerException("a is marked non-null but is null");
        }
        if (b == null) {
            throw new NullPointerException("b is marked non-null but is null");
        }
        if (a.equals(b)) {
            return a;
        }
        long amount = a.getAmount();
        ChronoUnit chronoUnit = a.getChronoUnit();
        if (b.getChronoUnit().compareTo(chronoUnit) < 0) {
            amount = TsUnit.getLowestAmount(amount, chronoUnit, b.getChronoUnit());
            chronoUnit = b.getChronoUnit();
        }
        amount = TsUnit.gcd(amount, b.getAmount());
        return TsUnit.of(amount, chronoUnit);
    }

    private static long gcd(long a, long b) {
        while (b > 0L) {
            long temp = b;
            b = a % b;
            a = temp;
        }
        return a;
    }

    private static TsUnit parseDatePattern(CharSequence text) {
        Matcher m = DATE_PATTERN.matcher(text);
        if (m.matches()) {
            int amount = Integer.parseInt(m.group(1));
            switch (m.group(2).charAt(0)) {
                case 'Y': {
                    return TsUnit.of(amount, ChronoUnit.YEARS);
                }
                case 'M': {
                    return TsUnit.of(amount, ChronoUnit.MONTHS);
                }
                case 'W': {
                    return TsUnit.of(amount, ChronoUnit.WEEKS);
                }
                case 'D': {
                    return TsUnit.of(amount, ChronoUnit.DAYS);
                }
            }
        }
        throw new DateTimeParseException("Text cannot be parsed to a freq", text, 0);
    }

    private static TsUnit parseTimePattern(CharSequence text) {
        Matcher m = TIME_PATTERN.matcher(text);
        if (m.matches()) {
            double amount = Double.parseDouble(m.group(1));
            switch (m.group(2).charAt(0)) {
                case 'H': {
                    return TsUnit.of((long)amount, ChronoUnit.HOURS);
                }
                case 'M': {
                    return TsUnit.of((long)amount, ChronoUnit.MINUTES);
                }
                case 'S': {
                    return TsUnit.of((long)amount, ChronoUnit.SECONDS);
                }
            }
        }
        throw new DateTimeParseException("Text cannot be parsed to a freq", text, 0);
    }

    private static long getLowestAmount(long lowestAmount, ChronoUnit oldUnit, ChronoUnit newUnit) {
        return oldUnit.compareTo(ChronoUnit.DAYS) > 0 && newUnit.compareTo(ChronoUnit.DAYS) <= 0 ? 1L : lowestAmount * CHRONO_UNIT_RATIOS_ON_SECONDS[oldUnit.ordinal()][newUnit.ordinal()];
    }

    private static long[][] computeChronoUnitRatiosOnSeconds() {
        ChronoUnit[] units = ChronoUnit.values();
        long[][] result = new long[units.length][units.length];
        for (ChronoUnit oldUnit : units) {
            for (ChronoUnit newUnit : units) {
                result[oldUnit.ordinal()][newUnit.ordinal()] = TsUnit.hasSeconds(oldUnit) && TsUnit.hasSeconds(newUnit) ? oldUnit.getDuration().dividedBy(newUnit.getDuration().getSeconds()).getSeconds() : 0L;
            }
        }
        return result;
    }

    private static boolean hasSeconds(ChronoUnit o) {
        return o.getDuration().getSeconds() > 0L;
    }

    @Generated
    public long getAmount() {
        return this.amount;
    }

    @NonNull
    @Generated
    public ChronoUnit getChronoUnit() {
        return this.chronoUnit;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TsUnit)) {
            return false;
        }
        TsUnit other = (TsUnit)o;
        if (this.getAmount() != other.getAmount()) {
            return false;
        }
        ChronoUnit this$chronoUnit = this.getChronoUnit();
        ChronoUnit other$chronoUnit = other.getChronoUnit();
        return !(this$chronoUnit == null ? other$chronoUnit != null : !this$chronoUnit.equals(other$chronoUnit));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $amount = this.getAmount();
        result = result * 59 + (int)($amount >>> 32 ^ $amount);
        ChronoUnit $chronoUnit = this.getChronoUnit();
        result = result * 59 + ($chronoUnit == null ? 43 : $chronoUnit.hashCode());
        return result;
    }

    @Generated
    private TsUnit(long amount, @NonNull ChronoUnit chronoUnit) {
        if (chronoUnit == null) {
            throw new NullPointerException("chronoUnit is marked non-null but is null");
        }
        this.amount = amount;
        this.chronoUnit = chronoUnit;
    }
}

