/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.diagnostics;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import jdplus.sa.base.api.SaDiagnosticsFactory;
import jdplus.sa.base.core.diagnostics.SpectralDiagnostics;
import jdplus.sa.base.core.diagnostics.SpectralDiagnosticsConfiguration;
import jdplus.toolkit.base.api.information.Explorable;
import jdplus.toolkit.base.api.processing.Diagnostics;
import lombok.NonNull;

public class SpectralDiagnosticsFactory<R extends Explorable>
implements SaDiagnosticsFactory<SpectralDiagnosticsConfiguration, R> {
    public static final String SEAS = "spectral seas peaks";
    public static final String TD = "spectral td peaks";
    public static final String NAME = "Visual spectral analysis";
    public static final List<String> ALL = Collections.unmodifiableList(Arrays.asList("spectral seas peaks", "spectral td peaks"));
    private final SpectralDiagnosticsConfiguration config;
    private final Function<R, SpectralDiagnostics.Input> extractor;

    public SpectralDiagnosticsFactory(@NonNull SpectralDiagnosticsConfiguration config, @NonNull Function<R, SpectralDiagnostics.Input> extractor) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (extractor == null) {
            throw new NullPointerException("extractor is marked non-null but is null");
        }
        this.config = config;
        this.extractor = extractor;
    }

    public SpectralDiagnosticsConfiguration getConfiguration() {
        return this.config;
    }

    public SpectralDiagnosticsFactory<R> with(SpectralDiagnosticsConfiguration config) {
        return new SpectralDiagnosticsFactory<R>(config, this.extractor);
    }

    public String getName() {
        return NAME;
    }

    public List<String> getTestDictionary() {
        return ALL;
    }

    public Diagnostics of(R rslts) {
        return SpectralDiagnostics.of(this.config, this.extractor.apply(rslts));
    }

    public SaDiagnosticsFactory.Scope getScope() {
        return SaDiagnosticsFactory.Scope.Preliminary;
    }

    public int getOrder() {
        return 100;
    }
}

