## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.width = 8,
  fig.height = 5
)

## ----setup, echo=FALSE--------------------------------------------------------
library(statisR)

## ----eval=FALSE---------------------------------------------------------------
# install.packages("statisR", dependencies=TRUE)

## -----------------------------------------------------------------------------
DT1 <- read.table("STATIS_TABLE1.csv", header = TRUE, sep = ",", dec = ".", row.names = 1)
DT1

## ----echo=FALSE---------------------------------------------------------------
DT2 <- read.table("STATIS_TABLE2.csv", header = TRUE, sep = ",", dec = ".", row.names = 1)
DT3 <- read.table("STATIS_TABLE3.csv", header = TRUE, sep = ",", dec = ".", row.names = 1)
DT4 <- read.table("STATIS_TABLE4.csv", header = TRUE, sep = ",", dec = ".", row.names = 1)

## -----------------------------------------------------------------------------
rows <- paste0("Wine", 1:6)

expert1 <- data.frame(
  fruity = c(1, 5, 6, 7, 2, 3),
  woody  = c(6, 3, 1, 1, 5, 4),
  coffee = c(7, 2, 1, 2, 4, 4),
  row.names = rows
)

expert2 <- data.frame(
  red_fruit = c(2, 4, 5, 7, 3, 3),
  roasted   = c(5, 4, 2, 2, 5, 5),
  vanillin  = c(7, 4, 1, 1, 6, 4),
  woody     = c(6, 2, 1, 2, 5, 5),
  row.names = rows
)

expert3 <- data.frame(
  fruity = c(3, 4, 7, 2, 2, 1),
  butter = c(6, 4, 1, 2, 6, 7),
  woody  = c(7, 3, 1, 2, 6, 5),
  row.names = rows
)

labels <- c("Expert 1", "Expert 2", "Expert 3")

## -----------------------------------------------------------------------------
res <- statis(list(expert1, expert2, expert3), table.labels = labels)

## ----warning=FALSE------------------------------------------------------------
inter <- res$circle.inter
inter.graph <- plot.statis.circle(inter$points, inertia = inter$inertia, labels = inter$labels, title = inter$title)
inter.graph

## ----warning=FALSE------------------------------------------------------------
intra <- res$circle.intra
intra.graph <- plot.statis.circle(intra$points, inertia = intra$inertia, labels = intra$labels, title = intra$title)
intra.graph

## ----warning=FALSE------------------------------------------------------------
individuals <- res$plane.individuals
ind.graph <- plot.statis.plane(individuals$points, inertia = individuals$inertia, labels = individuals$labels, title = individuals$title)
ind.graph

## ----warning=FALSE------------------------------------------------------------
evolution <- res$plane.evolution
evol.graph <- plot.statis.plane(evolution$points, inertia = evolution$inertia, labels = evolution$labels, title = evolution$title)
evol.graph

## -----------------------------------------------------------------------------
res <- statis(list(expert1, expert2, expert3), selected.tables = c(1, 3), table.labels = labels)

## ----warning=FALSE------------------------------------------------------------
inter <- res$circle.inter
inter.graph <- plot.statis.circle(inter$points, inertia = inter$inertia, labels = inter$labels, title = inter$title)
inter.graph

## ----warning=FALSE------------------------------------------------------------
intra <- res$circle.intra
intra.graph <- plot.statis.circle(intra$points, inertia = intra$inertia, labels = intra$labels, title = intra$title)
intra.graph

## -----------------------------------------------------------------------------
res <- statis(list(expert1, expert2, expert3), selected.rows = c(1, 5), table.labels = labels)

## ----warning=FALSE------------------------------------------------------------
individuals <- res$plane.individuals
ind.graph <- plot.statis.plane(individuals$points, inertia = individuals$inertia, labels = individuals$labels, title = individuals$title)
ind.graph

## ----warning=FALSE------------------------------------------------------------
evolution <- res$plane.evolution
evol.graph <- plot.statis.plane(evolution$points, inertia = evolution$inertia, labels = evolution$labels, title = evolution$title)
evol.graph

## -----------------------------------------------------------------------------
res <- statis(list(expert1, expert2, expert3), selected.rows = c(3, 4), table.labels = labels)

## ----warning=FALSE------------------------------------------------------------
individuals <- res$plane.individuals
ind.graph <- plot.statis.plane(individuals$points, inertia = individuals$inertia, labels = individuals$labels, title = individuals$title)
ind.graph

## ----warning=FALSE------------------------------------------------------------
evolution <- res$plane.evolution
evol.graph <- plot.statis.plane(evolution$points, inertia = evolution$inertia, labels = evolution$labels, title = evolution$title)
evol.graph

## -----------------------------------------------------------------------------
res <- statis(list(expert1, expert2, expert3), selected.tables = c(1, 3), selected.rows = c(1, 4), labels)

## ----warning=FALSE------------------------------------------------------------
inter <- res$circle.inter
inter.graph <- plot.statis.circle(inter$points, inertia = inter$inertia, labels = inter$labels, title = inter$title)
inter.graph

## ----warning=FALSE------------------------------------------------------------
intra <- res$circle.intra
intra.graph <- plot.statis.circle(intra$points, inertia = intra$inertia, labels = intra$labels, title = intra$title)
intra.graph

## ----warning=FALSE------------------------------------------------------------
individuals <- res$plane.individuals
ind.graph <- plot.statis.plane(individuals$points, inertia = individuals$inertia, labels = individuals$labels, title = individuals$title)
ind.graph

## ----warning=FALSE------------------------------------------------------------
evolution <- res$plane.evolution
evol.graph <- plot.statis.plane(evolution$points, inertia = evolution$inertia, labels = evolution$labels, title = evolution$title)
evol.graph

## -----------------------------------------------------------------------------
M1 <- read.table("STATIS_TABLE1.csv", header = TRUE, sep = ",", dec = ".", row.names = 1)
M2 <- read.table("STATIS_TABLE2.csv", header = TRUE, sep = ",", dec = ".", row.names = 1)
M3 <- read.table("STATIS_TABLE3.csv", header = TRUE, sep = ",", dec = ".", row.names = 1)
M4 <- read.table("STATIS_TABLE4.csv", header = TRUE, sep = ",", dec = ".", row.names = 1)

M1
M2
M3
M4

## -----------------------------------------------------------------------------
labels <- c("Measurement 1", "Measurement 2", "Measurement 3", "Measurement 4")

res <- statis(list(M1, M2, M3, M4), table.labels = labels)

## ----warning=FALSE------------------------------------------------------------
inter <- res$circle.inter
inter.graph <- plot.statis.circle(inter$points, inertia = inter$inertia, labels = inter$labels, title = inter$title)
inter.graph

## ----warning=FALSE------------------------------------------------------------
intra <- res$circle.intra
intra.graph <- plot.statis.circle(intra$points, inertia = intra$inertia, labels = intra$labels, title = intra$title)
intra.graph

## ----warning=FALSE------------------------------------------------------------
individuals <- res$plane.individuals
ind.graph <- plot.statis.plane(individuals$points, inertia = individuals$inertia, labels = individuals$labels, title = individuals$title)
ind.graph

## ----warning=FALSE------------------------------------------------------------
evolution <- res$plane.evolution
evol.graph <- plot.statis.plane(evolution$points, inertia = evolution$inertia, labels = evolution$labels, title = evolution$title)
evol.graph

## -----------------------------------------------------------------------------
res <- statis(list(M1, M2, M3, M4), selected.tables = c(2), table.labels = labels)

## ----warning=FALSE------------------------------------------------------------
inter <- res$circle.inter
inter.graph <- plot.statis.circle(inter$points, inertia = inter$inertia, labels = inter$labels, title = inter$title)
inter.graph

## ----warning=FALSE------------------------------------------------------------
intra <- res$circle.intra
intra.graph <- plot.statis.circle(intra$points, inertia = intra$inertia, labels = intra$labels, title = intra$title)
intra.graph

## -----------------------------------------------------------------------------
res <- statis(list(M1, M2, M3, M4), selected.rows = c(3), table.labels = labels)

## ----warning=FALSE------------------------------------------------------------
individuals <- res$plane.individuals
ind.graph <- plot.statis.plane(individuals$points, inertia = individuals$inertia, labels = individuals$labels, title = individuals$title)
ind.graph

## ----warning=FALSE------------------------------------------------------------
evolution <- res$plane.evolution
evol.graph <- plot.statis.plane(evolution$points, inertia = evolution$inertia, labels = evolution$labels, title = evolution$title)
evol.graph

## -----------------------------------------------------------------------------
res <- statis(list(M1, M2, M3, M4), selected.tables = c(2), selected.rows = c(3), table.labels = labels)

## ----warning=FALSE------------------------------------------------------------
inter <- res$circle.inter
inter.graph <- plot.statis.circle(inter$points, inertia = inter$inertia, labels = inter$labels, title = inter$title)
inter.graph

## ----warning=FALSE------------------------------------------------------------
intra <- res$circle.intra
intra.graph <- plot.statis.circle(intra$points, inertia = intra$inertia, labels = intra$labels, title = intra$title)
intra.graph

## ----warning=FALSE------------------------------------------------------------
individuals <- res$plane.individuals
ind.graph <- plot.statis.plane(individuals$points, inertia = individuals$inertia, labels = individuals$labels, title = individuals$title)
ind.graph

## ----warning=FALSE------------------------------------------------------------
evolution <- res$plane.evolution
evol.graph <- plot.statis.plane(evolution$points, inertia = evolution$inertia, labels = evolution$labels, title = evolution$title)
evol.graph

## -----------------------------------------------------------------------------
Tuis5_95 <- read.table("Tuis5_95.csv", header=TRUE, sep=';', dec=',')
Tuis5_95

## -----------------------------------------------------------------------------
Tuis5_95 <- read.table("Tuis5_95.csv", header=TRUE, sep=';', dec=',')
Tuis5_96 <- read.table("Tuis5_96.csv", header=TRUE, sep=';', dec=',')
Tuis5_97 <- read.table("Tuis5_97.csv", header=TRUE, sep=';', dec=',')
Tuis5_98 <- read.table("Tuis5_98.csv", header=TRUE, sep=';', dec=',')

labels = c("95","96","97","98")

res <- statis.dual(list(Tuis5_95, Tuis5_96, Tuis5_97, Tuis5_98), labels.tables = labels)

## -----------------------------------------------------------------------------
plot.statis.dual.circle(points.list = list(res$interstructure), labels = res$labels.tables) + ggplot2::ggtitle("Interstructure")

## -----------------------------------------------------------------------------
plot.statis.dual.circle(list(res$supervariables), labels = row.names(res$supervariables)) + ggplot2::ggtitle("Correlation (all variables)")

## -----------------------------------------------------------------------------
selected.variables <- c("Ph", "Temp", "DBO", "ST", "PO4", "NO3", "POD", "Cal")

superv.sel.df <- select.super.variables(res$supervariables, res$vars.names, selected.variables)

plot.statis.dual.circle(list(superv.sel.df), labels = row.names(superv.sel.df)) + ggplot2::ggtitle("Correlation (selected variables)")

## -----------------------------------------------------------------------------
vars.A <- c("Ph","ST","NO3")
plot.statis.dual.trajectories(vars = vars.A, trajectories = res$trajectories, labels.tables = res$labels.tables) + ggplot2::ggtitle(sprintf("Trajectories (%s)", paste(vars.A, collapse = ", ")))

vars.B <- c("OD","DBO","PO4")
plot.statis.dual.trajectories(vars = vars.B, trajectories = res$trajectories, labels.tables = res$labels.tables) + ggplot2::ggtitle(sprintf("Trajectories (%s)", paste(vars.B, collapse = ", ")))

# If you want to select an specific variable
vars.1 <- "Temp"
plot.statis.dual.trajectories(vars = vars.1, trajectories = res$trajectories, labels.tables = res$labels.tables) + ggplot2::ggtitle(sprintf("Trajectory (%s)", vars.1))

## -----------------------------------------------------------------------------
plot.statis.dual.trajectories(vars = res$vars.names, trajectories = res$trajectories, labels.tables = res$labels.tables)

## -----------------------------------------------------------------------------
vars <- c("Ozone","Solar.R","Wind","Temp")
AQ <- na.omit(airquality[, c(vars, "Month")])
Z  <- split(AQ[ , vars], AQ$Month)        # list(Z5, Z6, Z7, Z8, Z9)
names(Z) <- paste0("M", names(Z))         # "M5","M6","M7","M8","M9"
Z <- lapply(Z, as.matrix)

## -----------------------------------------------------------------------------
labels <- c("May","June","July","August","September")
res  <- statis.dual(Z, labels.tables = labels)

## ----warning=FALSE------------------------------------------------------------
interstructure <- list(res$interstructure)
labels <- res$labels.tables

plot.statis.dual.circle(points.list = interstructure, labels = labels) + ggplot2::ggtitle("Airquality (NY): Interstructure by Month")

## ----warning=FALSE------------------------------------------------------------
plot.statis.dual.circle(list(res$supervariables), labels = row.names(res$supervariables)) + ggplot2::ggtitle("Airquality (NY): Correlation (all variables)")

## ----warning=FALSE------------------------------------------------------------
selected.variables <- c("Ozone","Wind","Temp")

superv.sel.df <- select.super.variables(res$supervariables, res$vars.names, selected.variables)

plot.statis.dual.circle(list(superv.sel.df), labels = row.names(superv.sel.df)) + ggplot2::ggtitle("Airquality (NY): Correlation (selected variables)")

## ----warning=FALSE------------------------------------------------------------
vars.A <- c("Ozone","Temp")
p.tray.A <- plot.statis.dual.trajectories(vars = vars.A, trajectories = res$trajectories, labels.tables = labels) + ggplot2::ggtitle(sprintf("Airquality (NY): Trajectories (%s)", paste(vars.A, collapse = ", ")))
p.tray.A

vars.B <- c("Solar.R","Wind")
p.tray.B <- plot.statis.dual.trajectories(vars = vars.B, trajectories = res$trajectories, labels.tables = labels) + ggplot2::ggtitle(sprintf("Airquality (NY): Trajectories (%s)", paste(vars.B, collapse = ", ")))
p.tray.B

vars.1 <- "Ozone"
p.tray.1 <- plot.statis.dual.trajectories(vars = vars.1, trajectories = res$trajectories, labels.tables = labels) + ggplot2::ggtitle(sprintf("Airquality (NY): Trajectory (%s)", vars.1))
p.tray.1

## ----warning=FALSE------------------------------------------------------------
p.tray.all <- plot.statis.dual.trajectories(vars = res$vars.names, trajectories = res$trajectories, labels.tables = res$labels.tables)
p.tray.all

