/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.data.analysis;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.data.DataWindow;
import jdplus.toolkit.base.core.data.analysis.DurbinAlgorithm;
import jdplus.toolkit.base.core.math.linearsystem.QRLeastSquaresSolution;
import jdplus.toolkit.base.core.math.linearsystem.QRLeastSquaresSolver;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixException;

public class AutoRegressiveSpectrum {
    public static final int MAX_AR = 50;
    private double[] ar;
    private double sig;
    private final Method method_;

    public AutoRegressiveSpectrum(Method m) {
        this.method_ = m;
    }

    public boolean process(DoubleSeq data, int nar) {
        int nlags;
        this.clear();
        int n = nlags = nar == 0 ? AutoRegressiveSpectrum.computeDefaultLags(data.length()) : nar;
        if (nlags < 0) {
            return false;
        }
        switch (this.method_.ordinal()) {
            case 1: {
                this.computeDurbin(data, nlags);
                break;
            }
            case 0: {
                this.computeOls(data, nlags);
            }
        }
        return this.ar != null;
    }

    private void clear() {
        this.ar = null;
        this.sig = 0.0;
    }

    private void computeDurbin(DoubleSeq data, int nar) {
        DurbinAlgorithm durbin = new DurbinAlgorithm();
        if (durbin.solve(data, nar)) {
            this.ar = durbin.getCoefficients();
        }
        this.sig = durbin.getInnovationVariance();
    }

    public static int computeDefaultLags(int n) {
        double ln = Math.log(n);
        int npi = (int)(ln * ln);
        if (npi > 50) {
            npi = 50;
        }
        if (npi > n - n / 4) {
            return -1;
        }
        return npi;
    }

    private void computeOls(DoubleSeq data, int nar) {
        try {
            int i;
            this.clear();
            int n = data.length();
            double[] all = new double[n];
            data.copyTo(all, 0);
            double m = 0.0;
            for (i = 0; i < all.length; ++i) {
                if (Double.isNaN(all[i])) {
                    all[i] = 0.0;
                    continue;
                }
                m += all[i];
            }
            m /= (double)all.length;
            i = 0;
            while (i < all.length) {
                int n2 = i++;
                all[n2] = all[n2] - m;
            }
            int nc = n - nar;
            if (nc < nar) {
                return;
            }
            FastMatrix M = FastMatrix.make(nc, nar);
            DataWindow rc = DataWindow.windowOf(all, nar, n, 1);
            DataBlockIterator cols = M.columnsIterator();
            while (cols.hasNext()) {
                cols.next().copy(rc.move(-1));
            }
            QRLeastSquaresSolution ls = QRLeastSquaresSolver.fastLeastSquares((DoubleSeq)DataBlock.of(all, nar, n, 1), M);
            this.ar = new double[nar];
            DoubleSeq c = ls.getB();
            DataBlock D = DataBlock.of(c);
            D.chs();
            this.ar = D.getStorage();
            this.sig = ls.getSsqErr() / (double)nc;
        }
        catch (MatrixException err) {
            this.clear();
        }
    }

    public double value(double f) {
        if (f < 0.0 || f > Math.PI) {
            throw new IllegalArgumentException();
        }
        double c2 = 1.0;
        double s2 = 0.0;
        for (int j = 0; j < this.ar.length; ++j) {
            double dj = (double)(j + 1) * f;
            c2 += this.ar[j] * Math.cos(dj);
            s2 += this.ar[j] * Math.sin(dj);
        }
        double p = this.sig / (c2 * c2 + s2 * s2);
        if (p <= 0.0) {
            return 0.0;
        }
        return Math.log10(p) * 10.0;
    }

    public double getSigma() {
        return this.sig;
    }

    public DoubleSeq getCoefficients() {
        return this.ar != null ? DoubleSeq.of((double[])this.ar) : DataBlock.EMPTY;
    }

    public static enum Method {
        Ols,
        Durbin;

    }
}

