/*
 * Decompiled with CFR 0.152.
 */
package ru.itmo.ctlab.gmwcs.solver.preprocessing;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ru.itmo.ctlab.virgo.gmwcs.graph.Node;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B)\u0012\"\u0010\u0002\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\f\u001a\u00020\u0005R-\u0010\u0002\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\r"}, d2={"Lru/itmo/ctlab/gmwcs/solver/preprocessing/MST;", "", "nodes", "", "Lru/itmo/ctlab/virgo/gmwcs/graph/Node;", "", "Lru/itmo/ctlab/gmwcs/solver/preprocessing/Distances;", "(Ljava/util/Map;)V", "getNodes", "()Ljava/util/Map;", "res", "Ljava/lang/Double;", "solve", "virgo-solver"})
public final class MST {
    private Double res;
    @NotNull
    private final Map<Node, Map<Node, Double>> nodes;

    /*
     * WARNING - void declaration
     */
    public final double solve() {
        void start;
        Map.Entry entry;
        if (this.res != null) {
            Double d = this.res;
            if (d == null) {
                Intrinsics.throwNpe();
            }
            return d;
        }
        this.res = 0.0;
        Set<Map.Entry<Node, Map<Node, Double>>> entries = this.nodes.entrySet();
        Map.Entry entry2 = entry = (Map.Entry)CollectionsKt.first((Iterable)entries);
        boolean bl = false;
        Node node = (Node)entry2.getKey();
        entry2 = entry;
        bl = false;
        Map neighbors = (Map)entry2.getValue();
        boolean bl2 = this.nodes.size() > 1;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean $i$a$-assert-MST$solve$32 = false;
            String $i$a$-assert-MST$solve$32 = "MST for non-tree";
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-MST$solve$32));
        }
        bl2 = this.nodes.size() == neighbors.size();
        bl3 = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean $i$a$-assert-MST$solve$42 = false;
            String $i$a$-assert-MST$solve$42 = "MST for non-clique";
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-MST$solve$42));
        }
        Set<Node> tree = SetsKt.mutableSetOf(start);
        while (tree.size() != this.nodes.size()) {
            Node best = null;
            double bestW = 0.0;
            for (Node t : tree) {
                Map<Node, Double> near;
                if (this.nodes.get(t) == null) {
                    Intrinsics.throwNpe();
                }
                Map<Node, Double> map = near;
                boolean bl4 = false;
                Iterator<Map.Entry<Node, Double>> iterator2 = map.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<Node, Double> entry3;
                    Map.Entry<Node, Double> entry4 = entry3 = iterator2.next();
                    boolean bl5 = false;
                    Node node2 = entry4.getKey();
                    if (tree.contains(node2)) continue;
                    if (best != null) {
                        Double d = near.get(node2);
                        if (d == null) {
                            Intrinsics.throwNpe();
                        }
                        if (!(((Number)d).doubleValue() < bestW)) continue;
                    }
                    best = node2;
                    Double d = near.get(node2);
                    if (d == null) {
                        Intrinsics.throwNpe();
                    }
                    bestW = ((Number)d).doubleValue();
                }
            }
            Node node3 = best;
            if (node3 == null) {
                Intrinsics.throwNpe();
            }
            tree.add(node3);
            Double d = this.res;
            if (d == null) {
                Intrinsics.throwNpe();
            }
            this.res = d + bestW;
        }
        Double d = this.res;
        if (d == null) {
            Intrinsics.throwNpe();
        }
        return d;
    }

    @NotNull
    public final Map<Node, Map<Node, Double>> getNodes() {
        return this.nodes;
    }

    public MST(@NotNull Map<Node, ? extends Map<Node, Double>> nodes) {
        Intrinsics.checkParameterIsNotNull(nodes, "nodes");
        this.nodes = nodes;
    }
}

