/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.univariate;

import jdplus.toolkit.base.core.ssf.DataResults;
import jdplus.toolkit.base.core.ssf.State;
import jdplus.toolkit.base.core.ssf.StateInfo;
import jdplus.toolkit.base.core.ssf.UpdateInformation;
import jdplus.toolkit.base.core.ssf.univariate.IFilteringResults;

public class FilteringErrors
implements IFilteringResults {
    private final DataResults e;
    private final DataResults f;
    private final boolean normalized_;

    public FilteringErrors(boolean normalized) {
        this.normalized_ = normalized;
        this.e = new DataResults();
        this.f = new DataResults();
    }

    public boolean isNormalized() {
        return this.normalized_;
    }

    public void prepare(int start, int end) {
        this.e.prepare(start, end);
        this.f.prepare(start, end);
    }

    @Override
    public void save(int t, State state, StateInfo info) {
    }

    @Override
    public void save(int t, UpdateInformation pe) {
        if (pe.isMissing()) {
            return;
        }
        double x = pe.get();
        double v = pe.getVariance();
        if (this.normalized_) {
            double s = Math.sqrt(v);
            this.e.save(t, x / s);
            this.f.save(t, s);
        } else {
            this.e.save(t, x);
            this.f.save(t, v);
        }
    }

    @Override
    public void clear() {
        this.e.clear();
        this.f.clear();
    }
}

