/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.constraints.cnf;

import choco.kernel.model.constraints.cnf.ALogicTree;
import choco.kernel.model.constraints.cnf.Node;
import choco.kernel.model.constraints.cnf.Singleton;
import choco.kernel.model.variables.integer.IntegerVariable;
import gnu.trove.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.Arrays;

public class LogicTreeToolBox {
    protected LogicTreeToolBox() {
    }

    public static void expandNot(ALogicTree t) {
        if (!t.isLit()) {
            if (t.isNot()) {
                t.flip();
            }
            ALogicTree[] children = t.getChildren();
            for (int i = 0; i < children.length; ++i) {
                if (children[i].isLit()) continue;
                LogicTreeToolBox.expandNot(children[i]);
            }
        }
    }

    public static void merge(ALogicTree.Operator op, ALogicTree t) {
        if (!t.isLit() && t.is(op)) {
            ALogicTree[] children = t.getChildren();
            for (int i = 0; i < children.length; ++i) {
                ALogicTree child = children[i];
                if (!child.is(op)) continue;
                LogicTreeToolBox.merge(op, child);
                ALogicTree[] subchildren = child.getChildren();
                t.removeChild(child);
                for (int j = 0; j < subchildren.length; ++j) {
                    t.addChild(subchildren[j]);
                }
            }
        }
    }

    public static ALogicTree developOr(ALogicTree t) {
        ALogicTree t1 = t.getAndChild();
        ALogicTree t2 = t.getChildBut(t1);
        Node tt = Node.and(new ALogicTree[0]);
        ALogicTree[] t1cs = t1.getChildren();
        for (int i = 0; i < t1cs.length; ++i) {
            ALogicTree t1c = t1cs[i];
            if (t2.isLit()) {
                ((ALogicTree)tt).addChild(Node.or(t1c, t2));
                continue;
            }
            ALogicTree[] t2cs = t2.getChildren();
            for (int j = 0; j < t2cs.length; ++j) {
                ALogicTree t2c = t2cs[j];
                ((ALogicTree)tt).addChild(Node.or(t1c, t2c));
            }
        }
        t.removeChild(t1);
        t.removeChild(t2);
        if (t.getNbChildren() == 0) {
            return tt;
        }
        t.addChild(tt);
        return t;
    }

    public static ALogicTree distribute(ALogicTree t) {
        if (!t.isLit()) {
            if (t.is(ALogicTree.Operator.AND)) {
                ALogicTree[] children = t.getChildren();
                for (int i = 0; i < children.length; ++i) {
                    children[i] = LogicTreeToolBox.distribute(children[i]);
                }
            } else {
                if (t.hasOrChild()) {
                    LogicTreeToolBox.merge(ALogicTree.Operator.OR, t);
                }
                if (t.hasAndChild() && t.getNbChildren() > 1) {
                    t = LogicTreeToolBox.distribute(LogicTreeToolBox.developOr(t));
                }
            }
            LogicTreeToolBox.merge(ALogicTree.Operator.AND, t);
        }
        return t;
    }

    public static ALogicTree simplify(ALogicTree t) {
        if (t.is(ALogicTree.Operator.OR)) {
            ALogicTree[] children = t.getChildren();
            TLongObjectHashMap<ALogicTree> lits = new TLongObjectHashMap<ALogicTree>();
            for (int i = 0; i < children.length; ++i) {
                IntegerVariable var = children[i].flattenBoolVar()[0];
                if (lits.containsKey(var.getIndex())) {
                    ALogicTree prev = (ALogicTree)lits.get(var.getIndex());
                    if (prev.type.equals((Object)children[i].type)) continue;
                    return Singleton.TRUE;
                }
                lits.put(var.getIndex(), children[i]);
            }
        } else if (!t.hasOrChild()) {
            ALogicTree[] children = t.getChildren();
            TLongObjectHashMap<ALogicTree> lits = new TLongObjectHashMap<ALogicTree>();
            for (int i = 0; i < children.length; ++i) {
                IntegerVariable var = children[i].flattenBoolVar()[0];
                if (lits.containsKey(var.getIndex())) {
                    ALogicTree prev = (ALogicTree)lits.get(var.getIndex());
                    if (prev.type.equals((Object)children[i].type)) continue;
                    return Singleton.FALSE;
                }
                lits.put(var.getIndex(), children[i]);
            }
        } else {
            ALogicTree[] children = t.getChildren();
            for (int i = 0; i < children.length; ++i) {
                if (children[i].isLit()) continue;
                children[i] = LogicTreeToolBox.simplify(children[i]);
            }
        }
        return t;
    }

    public static ALogicTree simplifySingleton(ALogicTree t) {
        if (!(Singleton.TRUE.equals(t) || Singleton.FALSE.equals(t) || t.isLit())) {
            ALogicTree[] children = t.getChildren();
            ArrayList<ALogicTree> toRemove = new ArrayList<ALogicTree>();
            for (int i = 0; i < children.length; ++i) {
                if (!Singleton.TRUE.equals(children[i])) continue;
                toRemove.add(children[i]);
            }
            for (ALogicTree lt : toRemove) {
                t.removeChild(lt);
            }
            if (t.getNbChildren() == 1) {
                return t.getChildren()[0];
            }
        }
        return t;
    }

    public static ALogicTree toCNF(ALogicTree t) {
        LogicTreeToolBox.expandNot(t);
        t = LogicTreeToolBox.distribute(t);
        if (t.is(ALogicTree.Operator.OR)) {
            Arrays.sort(t.getChildren());
        }
        ALogicTree[] children = t.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!children[i].is(ALogicTree.Operator.OR)) continue;
            Arrays.sort(children[i].getChildren());
        }
        t = LogicTreeToolBox.simplify(t);
        t = LogicTreeToolBox.simplifySingleton(t);
        return t;
    }
}

