test_that("filter_first_three_rows filters the first three rows of column y", {
  df <- data.frame(x = 1:4, y = 1:4)
  class(df) <- "dataframe_with_y"

  filtered_y <- filter_first_three_rows(df)

  expected_df <- data.frame(y = 1:3)

  expect_equal(filtered_y, expected_df)
})

test_that("filter_first_three_rows handles empty dataframe", {
  df <- data.frame(x = numeric(0), y = numeric(0))
  class(df) <- "dataframe_with_y"

  filtered_y <- filter_first_three_rows(df)

  expected_df <- data.frame(y = numeric(0))

  expect_equal(filtered_y, expected_df)
})

test_that("filter_first_three_rows handles dataframe with less than three rows", {
  df <- data.frame(x = 1:2, y = 1:2)
  class(df) <- "dataframe_with_y"

  filtered_y <- filter_first_three_rows(df)

  expected_df <- data.frame(y = 1:2)

  expect_equal(filtered_y, expected_df)
})

test_that("filter_first_three_rows filters the first three rows of column y for list input", {
  df1 <- data.frame(x = 1:4, y = 1:4)
  df2 <- data.frame(x = 5:8, y = 5:8)
  class(df1) <- "dataframe_with_y"
  class(df2) <- "dataframe_with_y"
  data_list <- list(df1, df2)

  filtered_y_list <- filter_first_three_rows(data_list)

  expected_list <- data_list

  expect_equal(filtered_y_list, expected_list)
})

test_that("filter_first_three_rows handles empty dataframe in list", {
  df1 <- data.frame(x = numeric(0), y = numeric(0))
  df2 <- data.frame(x = numeric(0), y = numeric(0))
  class(df1) <- "dataframe_with_y"
  class(df2) <- "dataframe_with_y"
  data_list <- list(df1, df2)

  filtered_y_list <- filter_first_three_rows(data_list)

  expected_list <- data_list

  expect_equal(filtered_y_list, expected_list)
})

test_that("filter_first_three_rows handles dataframe with less than three rows in list", {
  df1 <- data.frame(x = 1:2, y = 1:2)
  df2 <- data.frame(x = 3:4, y = 3:4)
  class(df1) <- "dataframe_with_y"
  class(df2) <- "dataframe_with_y"
  data_list <- list(df1, df2)

  filtered_y_list <- filter_first_three_rows(data_list)

  expected_list <- data_list

  expect_equal(filtered_y_list, expected_list)
})

test_that("filter_first_three_rows handles non-dataframe elements in list", {
  df1 <- data.frame(x = 1:4, y = 1:4)
  df2 <- data.frame(x = 5:8, y = 5:8)
  class(df1) <- "dataframe_with_y"
  class(df2) <- "dataframe_with_y"
  data_list <- list(df1, df2, "not a dataframe", data.frame(a = 1:3))

  filtered_y_list <- filter_first_three_rows(data_list)

  expected_list <- data_list

  expect_equal(filtered_y_list, expected_list)
})
