/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.regression;

import dr.inference.regression.NewRegressionJNIWrapper;

public class RegressionInCyclops {
    private final NewRegressionJNIWrapper wrapper;
    private final int instance;
    private final int dim;

    public RegressionInCyclops(String libraryFileName, int instance) {
        this.wrapper = NewRegressionJNIWrapper.getCyclops(libraryFileName);
        this.instance = instance;
        this.dim = this.getBetaSize();
    }

    public double getLogLikelihood() {
        return this.wrapper.getLogLikelihood(this.instance);
    }

    public void getLogLikelihoodGradient(double[] gradient) {
        assert (gradient.length == this.dim);
        this.wrapper.getLogLikelihoodGradient(this.instance, gradient);
    }

    public double[] getLogLikelihoodGradient() {
        double[] gradient = new double[this.dim];
        this.wrapper.getLogLikelihoodGradient(this.instance, gradient);
        return gradient;
    }

    public double getLogPrior() {
        return this.wrapper.getLogPrior(this.instance);
    }

    public double getBeta(int index) {
        return this.wrapper.getBeta(this.instance, index);
    }

    public void getBeta(double[] beta) {
        assert (beta.length == this.dim);
        int i = 0;
        while (i < this.dim) {
            beta[i] = this.wrapper.getBeta(this.instance, i);
            ++i;
        }
    }

    public int getBetaSize() {
        return this.wrapper.getBetaSize(this.instance);
    }

    public int hasOffset() {
        return this.wrapper.hasOffset(this.instance);
    }

    public double getHessian(int index1, int index2) {
        return this.wrapper.getHessian(this.instance, index1, index2);
    }

    public void setBeta(int index, double value) {
        this.wrapper.setBeta(this.instance, index, value);
    }

    public void setBeta(double[] values) {
        assert (values.length == this.dim);
        this.wrapper.setBeta(this.instance, values);
    }

    public double getHyperprior(int index) {
        return this.wrapper.getHyperprior(this.instance, index);
    }

    public void setHyperprior(int index, double value) {
        this.wrapper.setHyperprior(this.instance, index, value);
    }

    public void findMode() {
        this.wrapper.findMode(this.instance);
    }

    public int getUpdateCount() {
        return this.wrapper.getUpdateCount(this.instance);
    }

    public int getLikelihoodCount() {
        return this.wrapper.getLikelihoodCount(this.instance);
    }

    public void setPriorType(int type) {
        this.wrapper.setPriorType(this.instance, type);
    }

    public void makeDirty() {
        this.wrapper.makeDirty(this.instance);
    }
}

