/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class SdmxLogHandler
extends Handler {
    public static final String LOG_FORMAT = "%1$tFT%1$tT.%1$tL %2$-10s [%3$s] %4$s%5$s%n";
    private final Handler err = new ConsoleHandler();
    private final Handler out = new ConsoleHandler(){
        {
            this.setOutputStream(System.out);
        }
    };

    public SdmxLogHandler() {
        this.setFormatter(new DefaultFormatter());
    }

    @Override
    public void close() throws SecurityException {
        this.err.close();
        this.out.close();
    }

    @Override
    public void flush() {
        this.err.flush();
        this.out.flush();
    }

    @Override
    public void publish(LogRecord logRecord) {
        if (Level.WARNING == logRecord.getLevel() || Level.SEVERE == logRecord.getLevel()) {
            this.err.publish(logRecord);
        } else {
            this.out.publish(logRecord);
        }
    }

    @Override
    public void setLevel(Level level) throws SecurityException {
        this.err.setLevel(level);
        this.out.setLevel(level);
        super.setLevel(level);
    }

    @Override
    public void setFormatter(Formatter formatter) throws SecurityException {
        this.err.setFormatter(formatter);
        this.out.setFormatter(formatter);
        super.setFormatter(formatter);
    }

    @Override
    public void setErrorManager(ErrorManager errorManager) {
        this.err.setErrorManager(errorManager);
        this.out.setErrorManager(errorManager);
        super.setErrorManager(errorManager);
    }

    @Override
    public void setFilter(Filter filter) throws SecurityException {
        this.err.setFilter(filter);
        this.out.setFilter(filter);
        super.setFilter(filter);
    }

    private static class DefaultFormatter
    extends Formatter {
        private DefaultFormatter() {
        }

        @Override
        public String format(LogRecord logRecord) {
            String string;
            if (logRecord.getSourceClassName() != null) {
                string = logRecord.getSourceClassName();
                if (logRecord.getSourceMethodName() != null) {
                    string = string + " " + logRecord.getSourceMethodName();
                }
            } else {
                string = logRecord.getLoggerName();
            }
            String string2 = this.formatMessage(logRecord);
            String string3 = "";
            if (logRecord.getThrown() != null) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                printWriter.println();
                logRecord.getThrown().printStackTrace(printWriter);
                printWriter.close();
                string3 = stringWriter.toString();
            }
            return String.format(SdmxLogHandler.LOG_FORMAT, new Date(logRecord.getMillis()), logRecord.getLevel().getName(), string, string2, string3);
        }
    }
}

